package org.openqa.selenium.devtools.v128.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public class FailedRequestInfo {

    private final java.lang.String url;

    private final java.lang.String failureMessage;

    private final java.util.Optional<org.openqa.selenium.devtools.v128.network.model.RequestId> requestId;

    public FailedRequestInfo(java.lang.String url, java.lang.String failureMessage, java.util.Optional<org.openqa.selenium.devtools.v128.network.model.RequestId> requestId) {
        this.url = java.util.Objects.requireNonNull(url, "url is required");
        this.failureMessage = java.util.Objects.requireNonNull(failureMessage, "failureMessage is required");
        this.requestId = requestId;
    }

    /**
     * The URL that failed to load.
     */
    public java.lang.String getUrl() {
        return url;
    }

    /**
     * The failure message for the failed request.
     */
    public java.lang.String getFailureMessage() {
        return failureMessage;
    }

    public java.util.Optional<org.openqa.selenium.devtools.v128.network.model.RequestId> getRequestId() {
        return requestId;
    }

    private static FailedRequestInfo fromJson(JsonInput input) {
        java.lang.String url = null;
        java.lang.String failureMessage = null;
        java.util.Optional<org.openqa.selenium.devtools.v128.network.model.RequestId> requestId = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "url":
                    url = input.nextString();
                    break;
                case "failureMessage":
                    failureMessage = input.nextString();
                    break;
                case "requestId":
                    requestId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v128.network.model.RequestId.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new FailedRequestInfo(url, failureMessage, requestId);
    }
}
