package org.openqa.selenium.devtools.v127.autofill.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public class CreditCard {

    private final java.lang.String number;

    private final java.lang.String name;

    private final java.lang.String expiryMonth;

    private final java.lang.String expiryYear;

    private final java.lang.String cvc;

    public CreditCard(java.lang.String number, java.lang.String name, java.lang.String expiryMonth, java.lang.String expiryYear, java.lang.String cvc) {
        this.number = java.util.Objects.requireNonNull(number, "number is required");
        this.name = java.util.Objects.requireNonNull(name, "name is required");
        this.expiryMonth = java.util.Objects.requireNonNull(expiryMonth, "expiryMonth is required");
        this.expiryYear = java.util.Objects.requireNonNull(expiryYear, "expiryYear is required");
        this.cvc = java.util.Objects.requireNonNull(cvc, "cvc is required");
    }

    /**
     * 16-digit credit card number.
     */
    public java.lang.String getNumber() {
        return number;
    }

    /**
     * Name of the credit card owner.
     */
    public java.lang.String getName() {
        return name;
    }

    /**
     * 2-digit expiry month.
     */
    public java.lang.String getExpiryMonth() {
        return expiryMonth;
    }

    /**
     * 4-digit expiry year.
     */
    public java.lang.String getExpiryYear() {
        return expiryYear;
    }

    /**
     * 3-digit card verification code.
     */
    public java.lang.String getCvc() {
        return cvc;
    }

    private static CreditCard fromJson(JsonInput input) {
        java.lang.String number = null;
        java.lang.String name = null;
        java.lang.String expiryMonth = null;
        java.lang.String expiryYear = null;
        java.lang.String cvc = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "number":
                    number = input.nextString();
                    break;
                case "name":
                    name = input.nextString();
                    break;
                case "expiryMonth":
                    expiryMonth = input.nextString();
                    break;
                case "expiryYear":
                    expiryYear = input.nextString();
                    break;
                case "cvc":
                    cvc = input.nextString();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new CreditCard(number, name, expiryMonth, expiryYear, cvc);
    }
}
