package org.openqa.selenium.devtools.v127.debugger.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public class BreakLocation {

    public enum Type {

        DEBUGGERSTATEMENT("debuggerStatement"), CALL("call"), RETURN("return");

        private String value;

        Type(String value) {
            this.value = value;
        }

        public static Type fromString(String s) {
            return java.util.Arrays.stream(Type.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within Type "));
        }

        public String toString() {
            return value;
        }

        public String toJson() {
            return value;
        }

        private static Type fromJson(JsonInput input) {
            return fromString(input.nextString());
        }
    }

    private final org.openqa.selenium.devtools.v127.runtime.model.ScriptId scriptId;

    private final java.lang.Integer lineNumber;

    private final java.util.Optional<java.lang.Integer> columnNumber;

    private final java.util.Optional<Type> type;

    public BreakLocation(org.openqa.selenium.devtools.v127.runtime.model.ScriptId scriptId, java.lang.Integer lineNumber, java.util.Optional<java.lang.Integer> columnNumber, java.util.Optional<Type> type) {
        this.scriptId = java.util.Objects.requireNonNull(scriptId, "scriptId is required");
        this.lineNumber = java.util.Objects.requireNonNull(lineNumber, "lineNumber is required");
        this.columnNumber = columnNumber;
        this.type = type;
    }

    /**
     * Script identifier as reported in the `Debugger.scriptParsed`.
     */
    public org.openqa.selenium.devtools.v127.runtime.model.ScriptId getScriptId() {
        return scriptId;
    }

    /**
     * Line number in the script (0-based).
     */
    public java.lang.Integer getLineNumber() {
        return lineNumber;
    }

    /**
     * Column number in the script (0-based).
     */
    public java.util.Optional<java.lang.Integer> getColumnNumber() {
        return columnNumber;
    }

    public java.util.Optional<Type> getType() {
        return type;
    }

    private static BreakLocation fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v127.runtime.model.ScriptId scriptId = null;
        java.lang.Integer lineNumber = 0;
        java.util.Optional<java.lang.Integer> columnNumber = java.util.Optional.empty();
        java.util.Optional<Type> type = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "scriptId":
                    scriptId = input.read(org.openqa.selenium.devtools.v127.runtime.model.ScriptId.class);
                    break;
                case "lineNumber":
                    lineNumber = input.nextNumber().intValue();
                    break;
                case "columnNumber":
                    columnNumber = java.util.Optional.ofNullable(input.nextNumber().intValue());
                    break;
                case "type":
                    type = java.util.Optional.ofNullable(Type.fromString(input.nextString()));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new BreakLocation(scriptId, lineNumber, columnNumber, type);
    }
}
