package org.openqa.selenium.devtools.v126.media.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Represents logged source line numbers reported in an error.
 * NOTE: file and line are from chromium c++ implementation code, not js.
 */
public class PlayerErrorSourceLocation {

    private final java.lang.String file;

    private final java.lang.Integer line;

    public PlayerErrorSourceLocation(java.lang.String file, java.lang.Integer line) {
        this.file = java.util.Objects.requireNonNull(file, "file is required");
        this.line = java.util.Objects.requireNonNull(line, "line is required");
    }

    public java.lang.String getFile() {
        return file;
    }

    public java.lang.Integer getLine() {
        return line;
    }

    private static PlayerErrorSourceLocation fromJson(JsonInput input) {
        java.lang.String file = null;
        java.lang.Integer line = 0;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "file":
                    file = input.nextString();
                    break;
                case "line":
                    line = input.nextNumber().intValue();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new PlayerErrorSourceLocation(file, line);
    }
}
