package org.openqa.selenium.devtools.v125.browser;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import java.util.Map;
import java.util.LinkedHashMap;
import org.openqa.selenium.json.JsonInput;

/**
 * The Browser domain defines methods and events for browser managing.
 */
public class Browser {

    /**
     * Set permission settings for given origin.
     */
    @Beta()
    public static Command<Void> setPermission(org.openqa.selenium.devtools.v125.browser.model.PermissionDescriptor permission, org.openqa.selenium.devtools.v125.browser.model.PermissionSetting setting, java.util.Optional<java.lang.String> origin, java.util.Optional<org.openqa.selenium.devtools.v125.browser.model.BrowserContextID> browserContextId) {
        java.util.Objects.requireNonNull(permission, "permission is required");
        java.util.Objects.requireNonNull(setting, "setting is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("permission", permission);
        params.put("setting", setting);
        origin.ifPresent(p -> params.put("origin", p));
        browserContextId.ifPresent(p -> params.put("browserContextId", p));
        return new Command<>("Browser.setPermission", Map.copyOf(params));
    }

    /**
     * Grant specific permissions to the given origin and reject all others.
     */
    @Beta()
    public static Command<Void> grantPermissions(java.util.List<org.openqa.selenium.devtools.v125.browser.model.PermissionType> permissions, java.util.Optional<java.lang.String> origin, java.util.Optional<org.openqa.selenium.devtools.v125.browser.model.BrowserContextID> browserContextId) {
        java.util.Objects.requireNonNull(permissions, "permissions is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("permissions", permissions);
        origin.ifPresent(p -> params.put("origin", p));
        browserContextId.ifPresent(p -> params.put("browserContextId", p));
        return new Command<>("Browser.grantPermissions", Map.copyOf(params));
    }

    /**
     * Reset all permission management for all origins.
     */
    public static Command<Void> resetPermissions(java.util.Optional<org.openqa.selenium.devtools.v125.browser.model.BrowserContextID> browserContextId) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        browserContextId.ifPresent(p -> params.put("browserContextId", p));
        return new Command<>("Browser.resetPermissions", Map.copyOf(params));
    }

    public enum SetDownloadBehaviorBehavior {

        DENY("deny"), ALLOW("allow"), ALLOWANDNAME("allowAndName"), DEFAULT("default");

        private String value;

        SetDownloadBehaviorBehavior(String value) {
            this.value = value;
        }

        public static SetDownloadBehaviorBehavior fromString(String s) {
            return java.util.Arrays.stream(SetDownloadBehaviorBehavior.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within SetDownloadBehaviorBehavior "));
        }

        public String toString() {
            return value;
        }

        public String toJson() {
            return value;
        }

        private static SetDownloadBehaviorBehavior fromJson(JsonInput input) {
            return fromString(input.nextString());
        }
    }

    /**
     * Set the behavior when downloading a file.
     */
    @Beta()
    public static Command<Void> setDownloadBehavior(SetDownloadBehaviorBehavior behavior, java.util.Optional<org.openqa.selenium.devtools.v125.browser.model.BrowserContextID> browserContextId, java.util.Optional<java.lang.String> downloadPath, java.util.Optional<java.lang.Boolean> eventsEnabled) {
        java.util.Objects.requireNonNull(behavior, "behavior is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("behavior", behavior);
        browserContextId.ifPresent(p -> params.put("browserContextId", p));
        downloadPath.ifPresent(p -> params.put("downloadPath", p));
        eventsEnabled.ifPresent(p -> params.put("eventsEnabled", p));
        return new Command<>("Browser.setDownloadBehavior", Map.copyOf(params));
    }

    /**
     * Cancel a download if in progress
     */
    @Beta()
    public static Command<Void> cancelDownload(java.lang.String guid, java.util.Optional<org.openqa.selenium.devtools.v125.browser.model.BrowserContextID> browserContextId) {
        java.util.Objects.requireNonNull(guid, "guid is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("guid", guid);
        browserContextId.ifPresent(p -> params.put("browserContextId", p));
        return new Command<>("Browser.cancelDownload", Map.copyOf(params));
    }

    /**
     * Close browser gracefully.
     */
    public static Command<Void> close() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Browser.close", Map.copyOf(params));
    }

    /**
     * Crashes browser on the main thread.
     */
    @Beta()
    public static Command<Void> crash() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Browser.crash", Map.copyOf(params));
    }

    /**
     * Crashes GPU process.
     */
    @Beta()
    public static Command<Void> crashGpuProcess() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Browser.crashGpuProcess", Map.copyOf(params));
    }

    public static class GetVersionResponse {

        private final java.lang.String protocolVersion;

        private final java.lang.String product;

        private final java.lang.String revision;

        private final java.lang.String userAgent;

        private final java.lang.String jsVersion;

        public GetVersionResponse(java.lang.String protocolVersion, java.lang.String product, java.lang.String revision, java.lang.String userAgent, java.lang.String jsVersion) {
            this.protocolVersion = java.util.Objects.requireNonNull(protocolVersion, "protocolVersion is required");
            this.product = java.util.Objects.requireNonNull(product, "product is required");
            this.revision = java.util.Objects.requireNonNull(revision, "revision is required");
            this.userAgent = java.util.Objects.requireNonNull(userAgent, "userAgent is required");
            this.jsVersion = java.util.Objects.requireNonNull(jsVersion, "jsVersion is required");
        }

        /**
         * Protocol version.
         */
        public java.lang.String getProtocolVersion() {
            return protocolVersion;
        }

        /**
         * Product name.
         */
        public java.lang.String getProduct() {
            return product;
        }

        /**
         * Product revision.
         */
        public java.lang.String getRevision() {
            return revision;
        }

        /**
         * User-Agent.
         */
        public java.lang.String getUserAgent() {
            return userAgent;
        }

        /**
         * V8 version.
         */
        public java.lang.String getJsVersion() {
            return jsVersion;
        }

        private static GetVersionResponse fromJson(JsonInput input) {
            java.lang.String protocolVersion = null;
            java.lang.String product = null;
            java.lang.String revision = null;
            java.lang.String userAgent = null;
            java.lang.String jsVersion = null;
            input.beginObject();
            while (input.hasNext()) {
                switch(input.nextName()) {
                    case "protocolVersion":
                        protocolVersion = input.nextString();
                        break;
                    case "product":
                        product = input.nextString();
                        break;
                    case "revision":
                        revision = input.nextString();
                        break;
                    case "userAgent":
                        userAgent = input.nextString();
                        break;
                    case "jsVersion":
                        jsVersion = input.nextString();
                        break;
                    default:
                        input.skipValue();
                        break;
                }
            }
            input.endObject();
            return new GetVersionResponse(protocolVersion, product, revision, userAgent, jsVersion);
        }
    }

    /**
     * Returns version information.
     */
    public static Command<org.openqa.selenium.devtools.v125.browser.Browser.GetVersionResponse> getVersion() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Browser.getVersion", Map.copyOf(params), input -> input.read(org.openqa.selenium.devtools.v125.browser.Browser.GetVersionResponse.class));
    }

    /**
     * Returns the command line switches for the browser process if, and only if
     * --enable-automation is on the commandline.
     */
    @Beta()
    public static Command<java.util.List<java.lang.String>> getBrowserCommandLine() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Browser.getBrowserCommandLine", Map.copyOf(params), ConverterFunctions.map("arguments", input -> input.readArray(java.lang.String.class)));
    }

    /**
     * Get Chrome histograms.
     */
    @Beta()
    public static Command<java.util.List<org.openqa.selenium.devtools.v125.browser.model.Histogram>> getHistograms(java.util.Optional<java.lang.String> query, java.util.Optional<java.lang.Boolean> delta) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        query.ifPresent(p -> params.put("query", p));
        delta.ifPresent(p -> params.put("delta", p));
        return new Command<>("Browser.getHistograms", Map.copyOf(params), ConverterFunctions.map("histograms", input -> input.readArray(org.openqa.selenium.devtools.v125.browser.model.Histogram.class)));
    }

    /**
     * Get a Chrome histogram by name.
     */
    @Beta()
    public static Command<org.openqa.selenium.devtools.v125.browser.model.Histogram> getHistogram(java.lang.String name, java.util.Optional<java.lang.Boolean> delta) {
        java.util.Objects.requireNonNull(name, "name is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("name", name);
        delta.ifPresent(p -> params.put("delta", p));
        return new Command<>("Browser.getHistogram", Map.copyOf(params), ConverterFunctions.map("histogram", org.openqa.selenium.devtools.v125.browser.model.Histogram.class));
    }

    /**
     * Get position and size of the browser window.
     */
    @Beta()
    public static Command<org.openqa.selenium.devtools.v125.browser.model.Bounds> getWindowBounds(org.openqa.selenium.devtools.v125.browser.model.WindowID windowId) {
        java.util.Objects.requireNonNull(windowId, "windowId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("windowId", windowId);
        return new Command<>("Browser.getWindowBounds", Map.copyOf(params), ConverterFunctions.map("bounds", org.openqa.selenium.devtools.v125.browser.model.Bounds.class));
    }

    public static class GetWindowForTargetResponse {

        private final org.openqa.selenium.devtools.v125.browser.model.WindowID windowId;

        private final org.openqa.selenium.devtools.v125.browser.model.Bounds bounds;

        public GetWindowForTargetResponse(org.openqa.selenium.devtools.v125.browser.model.WindowID windowId, org.openqa.selenium.devtools.v125.browser.model.Bounds bounds) {
            this.windowId = java.util.Objects.requireNonNull(windowId, "windowId is required");
            this.bounds = java.util.Objects.requireNonNull(bounds, "bounds is required");
        }

        /**
         * Browser window id.
         */
        public org.openqa.selenium.devtools.v125.browser.model.WindowID getWindowId() {
            return windowId;
        }

        /**
         * Bounds information of the window. When window state is 'minimized', the restored window
         * position and size are returned.
         */
        public org.openqa.selenium.devtools.v125.browser.model.Bounds getBounds() {
            return bounds;
        }

        private static GetWindowForTargetResponse fromJson(JsonInput input) {
            org.openqa.selenium.devtools.v125.browser.model.WindowID windowId = null;
            org.openqa.selenium.devtools.v125.browser.model.Bounds bounds = null;
            input.beginObject();
            while (input.hasNext()) {
                switch(input.nextName()) {
                    case "windowId":
                        windowId = input.read(org.openqa.selenium.devtools.v125.browser.model.WindowID.class);
                        break;
                    case "bounds":
                        bounds = input.read(org.openqa.selenium.devtools.v125.browser.model.Bounds.class);
                        break;
                    default:
                        input.skipValue();
                        break;
                }
            }
            input.endObject();
            return new GetWindowForTargetResponse(windowId, bounds);
        }
    }

    /**
     * Get the browser window that contains the devtools target.
     */
    @Beta()
    public static Command<org.openqa.selenium.devtools.v125.browser.Browser.GetWindowForTargetResponse> getWindowForTarget(java.util.Optional<org.openqa.selenium.devtools.v125.target.model.TargetID> targetId) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        targetId.ifPresent(p -> params.put("targetId", p));
        return new Command<>("Browser.getWindowForTarget", Map.copyOf(params), input -> input.read(org.openqa.selenium.devtools.v125.browser.Browser.GetWindowForTargetResponse.class));
    }

    /**
     * Set position and/or size of the browser window.
     */
    @Beta()
    public static Command<Void> setWindowBounds(org.openqa.selenium.devtools.v125.browser.model.WindowID windowId, org.openqa.selenium.devtools.v125.browser.model.Bounds bounds) {
        java.util.Objects.requireNonNull(windowId, "windowId is required");
        java.util.Objects.requireNonNull(bounds, "bounds is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("windowId", windowId);
        params.put("bounds", bounds);
        return new Command<>("Browser.setWindowBounds", Map.copyOf(params));
    }

    /**
     * Set dock tile details, platform-specific.
     */
    @Beta()
    public static Command<Void> setDockTile(java.util.Optional<java.lang.String> badgeLabel, java.util.Optional<java.lang.String> image) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        badgeLabel.ifPresent(p -> params.put("badgeLabel", p));
        image.ifPresent(p -> params.put("image", p));
        return new Command<>("Browser.setDockTile", Map.copyOf(params));
    }

    /**
     * Invoke custom browser commands used by telemetry.
     */
    @Beta()
    public static Command<Void> executeBrowserCommand(org.openqa.selenium.devtools.v125.browser.model.BrowserCommandId commandId) {
        java.util.Objects.requireNonNull(commandId, "commandId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("commandId", commandId);
        return new Command<>("Browser.executeBrowserCommand", Map.copyOf(params));
    }

    /**
     * Allows a site to use privacy sandbox features that require enrollment
     * without the site actually being enrolled. Only supported on page targets.
     */
    public static Command<Void> addPrivacySandboxEnrollmentOverride(java.lang.String url) {
        java.util.Objects.requireNonNull(url, "url is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("url", url);
        return new Command<>("Browser.addPrivacySandboxEnrollmentOverride", Map.copyOf(params));
    }

    public static Event<org.openqa.selenium.devtools.v125.browser.model.DownloadWillBegin> downloadWillBegin() {
        return new Event<>("Browser.downloadWillBegin", input -> input.read(org.openqa.selenium.devtools.v125.browser.model.DownloadWillBegin.class));
    }

    public static Event<org.openqa.selenium.devtools.v125.browser.model.DownloadProgress> downloadProgress() {
        return new Event<>("Browser.downloadProgress", input -> input.read(org.openqa.selenium.devtools.v125.browser.model.DownloadProgress.class));
    }
}
