/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v124.page.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@Beta
public class BackForwardCacheBlockingDetails {
    private final Optional<String> url;
    private final Optional<String> function;
    private final Integer lineNumber;
    private final Integer columnNumber;

    public BackForwardCacheBlockingDetails(Optional<String> url, Optional<String> function, Integer lineNumber, Integer columnNumber) {
        this.url = url;
        this.function = function;
        this.lineNumber = Objects.requireNonNull(lineNumber, "lineNumber is required");
        this.columnNumber = Objects.requireNonNull(columnNumber, "columnNumber is required");
    }

    public Optional<String> getUrl() {
        return this.url;
    }

    public Optional<String> getFunction() {
        return this.function;
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public Integer getColumnNumber() {
        return this.columnNumber;
    }

    private static BackForwardCacheBlockingDetails fromJson(JsonInput input) {
        Optional<String> url = Optional.empty();
        Optional<String> function = Optional.empty();
        Integer lineNumber = 0;
        Integer columnNumber = 0;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "url": {
                    url = Optional.ofNullable(input.nextString());
                    continue block12;
                }
                case "function": {
                    function = Optional.ofNullable(input.nextString());
                    continue block12;
                }
                case "lineNumber": {
                    lineNumber = input.nextNumber().intValue();
                    continue block12;
                }
                case "columnNumber": {
                    columnNumber = input.nextNumber().intValue();
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new BackForwardCacheBlockingDetails(url, function, lineNumber, columnNumber);
    }
}

