/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v124.page.model;

import java.util.Arrays;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

@Beta
public enum AutoResponseMode {
    NONE("none"),
    AUTOACCEPT("autoAccept"),
    AUTOREJECT("autoReject"),
    AUTOOPTOUT("autoOptOut");

    private String value;

    private AutoResponseMode(String value) {
        this.value = value;
    }

    public static AutoResponseMode fromString(String s) {
        return Arrays.stream(AutoResponseMode.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within AutoResponseMode "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static AutoResponseMode fromJson(JsonInput input) {
        return AutoResponseMode.fromString(input.nextString());
    }
}

