/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v124.css.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v124.css.model.RuleMatch;
import org.openqa.selenium.devtools.v124.dom.model.PseudoType;
import org.openqa.selenium.json.JsonInput;

public class PseudoElementMatches {
    private final PseudoType pseudoType;
    private final Optional<String> pseudoIdentifier;
    private final List<RuleMatch> matches;

    public PseudoElementMatches(PseudoType pseudoType, Optional<String> pseudoIdentifier, List<RuleMatch> matches) {
        this.pseudoType = Objects.requireNonNull(pseudoType, "pseudoType is required");
        this.pseudoIdentifier = pseudoIdentifier;
        this.matches = Objects.requireNonNull(matches, "matches is required");
    }

    public PseudoType getPseudoType() {
        return this.pseudoType;
    }

    public Optional<String> getPseudoIdentifier() {
        return this.pseudoIdentifier;
    }

    public List<RuleMatch> getMatches() {
        return this.matches;
    }

    private static PseudoElementMatches fromJson(JsonInput input) {
        PseudoType pseudoType = null;
        Optional<String> pseudoIdentifier = Optional.empty();
        List matches = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "pseudoType": {
                    pseudoType = (PseudoType)((Object)input.read(PseudoType.class));
                    continue block10;
                }
                case "pseudoIdentifier": {
                    pseudoIdentifier = Optional.ofNullable(input.nextString());
                    continue block10;
                }
                case "matches": {
                    matches = input.readArray(RuleMatch.class);
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new PseudoElementMatches(pseudoType, pseudoIdentifier, matches);
    }
}

