/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v123.css.model;

import java.util.Objects;
import org.openqa.selenium.json.JsonInput;

public class PlatformFontUsage {
    private final String familyName;
    private final String postScriptName;
    private final Boolean isCustomFont;
    private final Number glyphCount;

    public PlatformFontUsage(String familyName, String postScriptName, Boolean isCustomFont, Number glyphCount) {
        this.familyName = Objects.requireNonNull(familyName, "familyName is required");
        this.postScriptName = Objects.requireNonNull(postScriptName, "postScriptName is required");
        this.isCustomFont = Objects.requireNonNull(isCustomFont, "isCustomFont is required");
        this.glyphCount = Objects.requireNonNull(glyphCount, "glyphCount is required");
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public String getPostScriptName() {
        return this.postScriptName;
    }

    public Boolean getIsCustomFont() {
        return this.isCustomFont;
    }

    public Number getGlyphCount() {
        return this.glyphCount;
    }

    private static PlatformFontUsage fromJson(JsonInput input) {
        String familyName = null;
        String postScriptName = null;
        Boolean isCustomFont = false;
        Number glyphCount = 0;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "familyName": {
                    familyName = input.nextString();
                    continue block12;
                }
                case "postScriptName": {
                    postScriptName = input.nextString();
                    continue block12;
                }
                case "isCustomFont": {
                    isCustomFont = input.nextBoolean();
                    continue block12;
                }
                case "glyphCount": {
                    glyphCount = input.nextNumber();
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new PlatformFontUsage(familyName, postScriptName, isCustomFont, glyphCount);
    }
}

