package org.openqa.selenium.devtools.v123.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * A cookie should have been blocked by 3PCD but is exempted and stored from a response with the
 * corresponding reason. A cookie could only have at most one exemption reason.
 */
@org.openqa.selenium.Beta()
public class ExemptedSetCookieWithReason {

    private final org.openqa.selenium.devtools.v123.network.model.CookieExemptionReason exemptionReason;

    private final org.openqa.selenium.devtools.v123.network.model.Cookie cookie;

    public ExemptedSetCookieWithReason(org.openqa.selenium.devtools.v123.network.model.CookieExemptionReason exemptionReason, org.openqa.selenium.devtools.v123.network.model.Cookie cookie) {
        this.exemptionReason = java.util.Objects.requireNonNull(exemptionReason, "exemptionReason is required");
        this.cookie = java.util.Objects.requireNonNull(cookie, "cookie is required");
    }

    /**
     * The reason the cookie was exempted.
     */
    public org.openqa.selenium.devtools.v123.network.model.CookieExemptionReason getExemptionReason() {
        return exemptionReason;
    }

    /**
     * The cookie object representing the cookie.
     */
    public org.openqa.selenium.devtools.v123.network.model.Cookie getCookie() {
        return cookie;
    }

    private static ExemptedSetCookieWithReason fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v123.network.model.CookieExemptionReason exemptionReason = null;
        org.openqa.selenium.devtools.v123.network.model.Cookie cookie = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "exemptionReason":
                    exemptionReason = input.read(org.openqa.selenium.devtools.v123.network.model.CookieExemptionReason.class);
                    break;
                case "cookie":
                    cookie = input.read(org.openqa.selenium.devtools.v123.network.model.Cookie.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new ExemptedSetCookieWithReason(exemptionReason, cookie);
    }
}
