package org.openqa.selenium.devtools.v123.input.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public class DragData {

    private final java.util.List<org.openqa.selenium.devtools.v123.input.model.DragDataItem> items;

    private final java.util.Optional<java.util.List<java.lang.String>> files;

    private final java.lang.Integer dragOperationsMask;

    public DragData(java.util.List<org.openqa.selenium.devtools.v123.input.model.DragDataItem> items, java.util.Optional<java.util.List<java.lang.String>> files, java.lang.Integer dragOperationsMask) {
        this.items = java.util.Objects.requireNonNull(items, "items is required");
        this.files = files;
        this.dragOperationsMask = java.util.Objects.requireNonNull(dragOperationsMask, "dragOperationsMask is required");
    }

    public java.util.List<org.openqa.selenium.devtools.v123.input.model.DragDataItem> getItems() {
        return items;
    }

    /**
     * List of filenames that should be included when dropping
     */
    public java.util.Optional<java.util.List<java.lang.String>> getFiles() {
        return files;
    }

    /**
     * Bit field representing allowed drag operations. Copy = 1, Link = 2, Move = 16
     */
    public java.lang.Integer getDragOperationsMask() {
        return dragOperationsMask;
    }

    private static DragData fromJson(JsonInput input) {
        java.util.List<org.openqa.selenium.devtools.v123.input.model.DragDataItem> items = null;
        java.util.Optional<java.util.List<java.lang.String>> files = java.util.Optional.empty();
        java.lang.Integer dragOperationsMask = 0;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "items":
                    items = input.readArray(org.openqa.selenium.devtools.v123.input.model.DragDataItem.class);
                    break;
                case "files":
                    files = java.util.Optional.ofNullable(input.readArray(java.lang.String.class));
                    break;
                case "dragOperationsMask":
                    dragOperationsMask = input.nextNumber().intValue();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new DragData(items, files, dragOperationsMask);
    }
}
