package org.openqa.selenium.devtools.v123.css.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * CSS rule collection for a single pseudo style.
 */
public class PseudoElementMatches {

    private final org.openqa.selenium.devtools.v123.dom.model.PseudoType pseudoType;

    private final java.util.Optional<java.lang.String> pseudoIdentifier;

    private final java.util.List<org.openqa.selenium.devtools.v123.css.model.RuleMatch> matches;

    public PseudoElementMatches(org.openqa.selenium.devtools.v123.dom.model.PseudoType pseudoType, java.util.Optional<java.lang.String> pseudoIdentifier, java.util.List<org.openqa.selenium.devtools.v123.css.model.RuleMatch> matches) {
        this.pseudoType = java.util.Objects.requireNonNull(pseudoType, "pseudoType is required");
        this.pseudoIdentifier = pseudoIdentifier;
        this.matches = java.util.Objects.requireNonNull(matches, "matches is required");
    }

    /**
     * Pseudo element type.
     */
    public org.openqa.selenium.devtools.v123.dom.model.PseudoType getPseudoType() {
        return pseudoType;
    }

    /**
     * Pseudo element custom ident.
     */
    public java.util.Optional<java.lang.String> getPseudoIdentifier() {
        return pseudoIdentifier;
    }

    /**
     * Matches of CSS rules applicable to the pseudo style.
     */
    public java.util.List<org.openqa.selenium.devtools.v123.css.model.RuleMatch> getMatches() {
        return matches;
    }

    private static PseudoElementMatches fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v123.dom.model.PseudoType pseudoType = null;
        java.util.Optional<java.lang.String> pseudoIdentifier = java.util.Optional.empty();
        java.util.List<org.openqa.selenium.devtools.v123.css.model.RuleMatch> matches = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "pseudoType":
                    pseudoType = input.read(org.openqa.selenium.devtools.v123.dom.model.PseudoType.class);
                    break;
                case "pseudoIdentifier":
                    pseudoIdentifier = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "matches":
                    matches = input.readArray(org.openqa.selenium.devtools.v123.css.model.RuleMatch.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new PseudoElementMatches(pseudoType, pseudoIdentifier, matches);
    }
}
