package org.openqa.selenium.devtools.v123.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * This issue warns about third-party sites that are accessing cookies on the
 * current page, and have been permitted due to having a global metadata grant.
 * Note that in this context 'site' means eTLD+1. For example, if the URL
 * `https://example.test:80/web_page` was accessing cookies, the site reported
 * would be `example.test`.
 */
public class CookieDeprecationMetadataIssueDetails {

    private final java.util.List<java.lang.String> allowedSites;

    public CookieDeprecationMetadataIssueDetails(java.util.List<java.lang.String> allowedSites) {
        this.allowedSites = java.util.Objects.requireNonNull(allowedSites, "allowedSites is required");
    }

    public java.util.List<java.lang.String> getAllowedSites() {
        return allowedSites;
    }

    private static CookieDeprecationMetadataIssueDetails fromJson(JsonInput input) {
        java.util.List<java.lang.String> allowedSites = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "allowedSites":
                    allowedSites = input.readArray(java.lang.String.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new CookieDeprecationMetadataIssueDetails(allowedSites);
    }
}
