package org.openqa.selenium.devtools.v122.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public enum CookieOperation {

    SETCOOKIE("SetCookie"), READCOOKIE("ReadCookie");

    private String value;

    CookieOperation(String value) {
        this.value = value;
    }

    public static CookieOperation fromString(String s) {
        return java.util.Arrays.stream(CookieOperation.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within CookieOperation "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static CookieOperation fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
