package org.openqa.selenium.devtools.v122.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public class ReportingApiEndpointsChangedForOrigin {

    private final java.lang.String origin;

    private final java.util.List<org.openqa.selenium.devtools.v122.network.model.ReportingApiEndpoint> endpoints;

    public ReportingApiEndpointsChangedForOrigin(java.lang.String origin, java.util.List<org.openqa.selenium.devtools.v122.network.model.ReportingApiEndpoint> endpoints) {
        this.origin = java.util.Objects.requireNonNull(origin, "origin is required");
        this.endpoints = java.util.Objects.requireNonNull(endpoints, "endpoints is required");
    }

    /**
     * Origin of the document(s) which configured the endpoints.
     */
    public java.lang.String getOrigin() {
        return origin;
    }

    public java.util.List<org.openqa.selenium.devtools.v122.network.model.ReportingApiEndpoint> getEndpoints() {
        return endpoints;
    }

    private static ReportingApiEndpointsChangedForOrigin fromJson(JsonInput input) {
        java.lang.String origin = null;
        java.util.List<org.openqa.selenium.devtools.v122.network.model.ReportingApiEndpoint> endpoints = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "origin":
                    origin = input.nextString();
                    break;
                case "endpoints":
                    endpoints = input.readArray(org.openqa.selenium.devtools.v122.network.model.ReportingApiEndpoint.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new ReportingApiEndpointsChangedForOrigin(origin, endpoints);
    }
}
