package org.openqa.selenium.devtools.v120.storage.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Ad advertising element inside an interest group.
 */
public class InterestGroupAd {

    private final java.lang.String renderURL;

    private final java.util.Optional<java.lang.String> metadata;

    public InterestGroupAd(java.lang.String renderURL, java.util.Optional<java.lang.String> metadata) {
        this.renderURL = java.util.Objects.requireNonNull(renderURL, "renderURL is required");
        this.metadata = metadata;
    }

    public java.lang.String getRenderURL() {
        return renderURL;
    }

    public java.util.Optional<java.lang.String> getMetadata() {
        return metadata;
    }

    private static InterestGroupAd fromJson(JsonInput input) {
        java.lang.String renderURL = null;
        java.util.Optional<java.lang.String> metadata = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "renderURL":
                    renderURL = input.nextString();
                    break;
                case "metadata":
                    metadata = java.util.Optional.ofNullable(input.nextString());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new InterestGroupAd(renderURL, metadata);
    }
}
