/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v119.network.model;

import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v119.network.model.ContentSecurityPolicySource;
import org.openqa.selenium.json.JsonInput;

@Beta
public class ContentSecurityPolicyStatus {
    private final String effectiveDirectives;
    private final Boolean isEnforced;
    private final ContentSecurityPolicySource source;

    public ContentSecurityPolicyStatus(String effectiveDirectives, Boolean isEnforced, ContentSecurityPolicySource source) {
        this.effectiveDirectives = Objects.requireNonNull(effectiveDirectives, "effectiveDirectives is required");
        this.isEnforced = Objects.requireNonNull(isEnforced, "isEnforced is required");
        this.source = Objects.requireNonNull(source, "source is required");
    }

    public String getEffectiveDirectives() {
        return this.effectiveDirectives;
    }

    public Boolean getIsEnforced() {
        return this.isEnforced;
    }

    public ContentSecurityPolicySource getSource() {
        return this.source;
    }

    private static ContentSecurityPolicyStatus fromJson(JsonInput input) {
        String effectiveDirectives = null;
        Boolean isEnforced = false;
        ContentSecurityPolicySource source = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "effectiveDirectives": {
                    effectiveDirectives = input.nextString();
                    continue block10;
                }
                case "isEnforced": {
                    isEnforced = input.nextBoolean();
                    continue block10;
                }
                case "source": {
                    source = (ContentSecurityPolicySource)((Object)input.read(ContentSecurityPolicySource.class));
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ContentSecurityPolicyStatus(effectiveDirectives, isEnforced, source);
    }
}

