package org.openqa.selenium.devtools.v118.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public enum AttributionReportingIssueType {

    PERMISSIONPOLICYDISABLED("PermissionPolicyDisabled"),
    UNTRUSTWORTHYREPORTINGORIGIN("UntrustworthyReportingOrigin"),
    INSECURECONTEXT("InsecureContext"),
    INVALIDHEADER("InvalidHeader"),
    INVALIDREGISTERTRIGGERHEADER("InvalidRegisterTriggerHeader"),
    SOURCEANDTRIGGERHEADERS("SourceAndTriggerHeaders"),
    SOURCEIGNORED("SourceIgnored"),
    TRIGGERIGNORED("TriggerIgnored"),
    OSSOURCEIGNORED("OsSourceIgnored"),
    OSTRIGGERIGNORED("OsTriggerIgnored"),
    INVALIDREGISTEROSSOURCEHEADER("InvalidRegisterOsSourceHeader"),
    INVALIDREGISTEROSTRIGGERHEADER("InvalidRegisterOsTriggerHeader"),
    WEBANDOSHEADERS("WebAndOsHeaders"),
    NOWEBOROSSUPPORT("NoWebOrOsSupport"),
    NAVIGATIONREGISTRATIONWITHOUTTRANSIENTUSERACTIVATION("NavigationRegistrationWithoutTransientUserActivation");

    private String value;

    AttributionReportingIssueType(String value) {
        this.value = value;
    }

    public static AttributionReportingIssueType fromString(String s) {
        return java.util.Arrays.stream(AttributionReportingIssueType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within AttributionReportingIssueType "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static AttributionReportingIssueType fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
