package org.openqa.selenium.devtools.v117.backgroundservice;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import java.util.Map;
import java.util.LinkedHashMap;
import org.openqa.selenium.json.JsonInput;

/**
 * Defines events for background web platform features.
 */
@Beta()
public class BackgroundService {

    /**
     * Enables event updates for the service.
     */
    public static Command<Void> startObserving(org.openqa.selenium.devtools.v117.backgroundservice.model.ServiceName service) {
        java.util.Objects.requireNonNull(service, "service is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("service", service);
        return new Command<>("BackgroundService.startObserving", Map.copyOf(params));
    }

    /**
     * Disables event updates for the service.
     */
    public static Command<Void> stopObserving(org.openqa.selenium.devtools.v117.backgroundservice.model.ServiceName service) {
        java.util.Objects.requireNonNull(service, "service is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("service", service);
        return new Command<>("BackgroundService.stopObserving", Map.copyOf(params));
    }

    /**
     * Set the recording state for the service.
     */
    public static Command<Void> setRecording(java.lang.Boolean shouldRecord, org.openqa.selenium.devtools.v117.backgroundservice.model.ServiceName service) {
        java.util.Objects.requireNonNull(shouldRecord, "shouldRecord is required");
        java.util.Objects.requireNonNull(service, "service is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("shouldRecord", shouldRecord);
        params.put("service", service);
        return new Command<>("BackgroundService.setRecording", Map.copyOf(params));
    }

    /**
     * Clears all stored data for the service.
     */
    public static Command<Void> clearEvents(org.openqa.selenium.devtools.v117.backgroundservice.model.ServiceName service) {
        java.util.Objects.requireNonNull(service, "service is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("service", service);
        return new Command<>("BackgroundService.clearEvents", Map.copyOf(params));
    }

    public static Event<org.openqa.selenium.devtools.v117.backgroundservice.model.RecordingStateChanged> recordingStateChanged() {
        return new Event<>("BackgroundService.recordingStateChanged", input -> input.read(org.openqa.selenium.devtools.v117.backgroundservice.model.RecordingStateChanged.class));
    }

    public static Event<org.openqa.selenium.devtools.v117.backgroundservice.model.BackgroundServiceEvent> backgroundServiceEventReceived() {
        return new Event<>("BackgroundService.backgroundServiceEventReceived", ConverterFunctions.map("backgroundServiceEvent", org.openqa.selenium.devtools.v117.backgroundservice.model.BackgroundServiceEvent.class));
    }
}
