/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v117.storage.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v117.network.model.TimeSinceEpoch;
import org.openqa.selenium.devtools.v117.storage.model.AttributionReportingAggregationKeysEntry;
import org.openqa.selenium.devtools.v117.storage.model.AttributionReportingFilterDataEntry;
import org.openqa.selenium.devtools.v117.storage.model.AttributionReportingSourceType;
import org.openqa.selenium.devtools.v117.storage.model.SignedInt64AsBase10;
import org.openqa.selenium.devtools.v117.storage.model.UnsignedInt64AsBase10;
import org.openqa.selenium.json.JsonInput;

@Beta
public class AttributionReportingSourceRegistration {
    private final TimeSinceEpoch time;
    private final Optional<Integer> expiry;
    private final Optional<Integer> eventReportWindow;
    private final Optional<Integer> aggregatableReportWindow;
    private final AttributionReportingSourceType type;
    private final String sourceOrigin;
    private final String reportingOrigin;
    private final List<String> destinationSites;
    private final UnsignedInt64AsBase10 eventId;
    private final SignedInt64AsBase10 priority;
    private final List<AttributionReportingFilterDataEntry> filterData;
    private final List<AttributionReportingAggregationKeysEntry> aggregationKeys;
    private final Optional<UnsignedInt64AsBase10> debugKey;

    public AttributionReportingSourceRegistration(TimeSinceEpoch time, Optional<Integer> expiry, Optional<Integer> eventReportWindow, Optional<Integer> aggregatableReportWindow, AttributionReportingSourceType type, String sourceOrigin, String reportingOrigin, List<String> destinationSites, UnsignedInt64AsBase10 eventId, SignedInt64AsBase10 priority, List<AttributionReportingFilterDataEntry> filterData, List<AttributionReportingAggregationKeysEntry> aggregationKeys, Optional<UnsignedInt64AsBase10> debugKey) {
        this.time = Objects.requireNonNull(time, "time is required");
        this.expiry = expiry;
        this.eventReportWindow = eventReportWindow;
        this.aggregatableReportWindow = aggregatableReportWindow;
        this.type = Objects.requireNonNull(type, "type is required");
        this.sourceOrigin = Objects.requireNonNull(sourceOrigin, "sourceOrigin is required");
        this.reportingOrigin = Objects.requireNonNull(reportingOrigin, "reportingOrigin is required");
        this.destinationSites = Objects.requireNonNull(destinationSites, "destinationSites is required");
        this.eventId = Objects.requireNonNull(eventId, "eventId is required");
        this.priority = Objects.requireNonNull(priority, "priority is required");
        this.filterData = Objects.requireNonNull(filterData, "filterData is required");
        this.aggregationKeys = Objects.requireNonNull(aggregationKeys, "aggregationKeys is required");
        this.debugKey = debugKey;
    }

    public TimeSinceEpoch getTime() {
        return this.time;
    }

    public Optional<Integer> getExpiry() {
        return this.expiry;
    }

    public Optional<Integer> getEventReportWindow() {
        return this.eventReportWindow;
    }

    public Optional<Integer> getAggregatableReportWindow() {
        return this.aggregatableReportWindow;
    }

    public AttributionReportingSourceType getType() {
        return this.type;
    }

    public String getSourceOrigin() {
        return this.sourceOrigin;
    }

    public String getReportingOrigin() {
        return this.reportingOrigin;
    }

    public List<String> getDestinationSites() {
        return this.destinationSites;
    }

    public UnsignedInt64AsBase10 getEventId() {
        return this.eventId;
    }

    public SignedInt64AsBase10 getPriority() {
        return this.priority;
    }

    public List<AttributionReportingFilterDataEntry> getFilterData() {
        return this.filterData;
    }

    public List<AttributionReportingAggregationKeysEntry> getAggregationKeys() {
        return this.aggregationKeys;
    }

    public Optional<UnsignedInt64AsBase10> getDebugKey() {
        return this.debugKey;
    }

    private static AttributionReportingSourceRegistration fromJson(JsonInput input) {
        TimeSinceEpoch time = null;
        Optional<Integer> expiry = Optional.empty();
        Optional<Integer> eventReportWindow = Optional.empty();
        Optional<Integer> aggregatableReportWindow = Optional.empty();
        AttributionReportingSourceType type = null;
        String sourceOrigin = null;
        String reportingOrigin = null;
        List destinationSites = null;
        UnsignedInt64AsBase10 eventId = null;
        SignedInt64AsBase10 priority = null;
        List filterData = null;
        List aggregationKeys = null;
        Optional<UnsignedInt64AsBase10> debugKey = Optional.empty();
        input.beginObject();
        block30: while (input.hasNext()) {
            switch (input.nextName()) {
                case "time": {
                    time = (TimeSinceEpoch)input.read(TimeSinceEpoch.class);
                    continue block30;
                }
                case "expiry": {
                    expiry = Optional.ofNullable(input.nextNumber().intValue());
                    continue block30;
                }
                case "eventReportWindow": {
                    eventReportWindow = Optional.ofNullable(input.nextNumber().intValue());
                    continue block30;
                }
                case "aggregatableReportWindow": {
                    aggregatableReportWindow = Optional.ofNullable(input.nextNumber().intValue());
                    continue block30;
                }
                case "type": {
                    type = (AttributionReportingSourceType)((Object)input.read(AttributionReportingSourceType.class));
                    continue block30;
                }
                case "sourceOrigin": {
                    sourceOrigin = input.nextString();
                    continue block30;
                }
                case "reportingOrigin": {
                    reportingOrigin = input.nextString();
                    continue block30;
                }
                case "destinationSites": {
                    destinationSites = (List)input.read(new TypeToken<List<String>>(){}.getType());
                    continue block30;
                }
                case "eventId": {
                    eventId = (UnsignedInt64AsBase10)input.read(UnsignedInt64AsBase10.class);
                    continue block30;
                }
                case "priority": {
                    priority = (SignedInt64AsBase10)input.read(SignedInt64AsBase10.class);
                    continue block30;
                }
                case "filterData": {
                    filterData = (List)input.read(new TypeToken<List<AttributionReportingFilterDataEntry>>(){}.getType());
                    continue block30;
                }
                case "aggregationKeys": {
                    aggregationKeys = (List)input.read(new TypeToken<List<AttributionReportingAggregationKeysEntry>>(){}.getType());
                    continue block30;
                }
                case "debugKey": {
                    debugKey = Optional.ofNullable((UnsignedInt64AsBase10)input.read(UnsignedInt64AsBase10.class));
                    continue block30;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new AttributionReportingSourceRegistration(time, expiry, eventReportWindow, aggregatableReportWindow, type, sourceOrigin, reportingOrigin, destinationSites, eventId, priority, filterData, aggregationKeys, debugKey);
    }
}

