/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v116.runtime.model;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public class SerializationOptions {
    private final Serialization serialization;
    private final Optional<Integer> maxDepth;

    public SerializationOptions(Serialization serialization, Optional<Integer> maxDepth) {
        this.serialization = Objects.requireNonNull(serialization, "serialization is required");
        this.maxDepth = maxDepth;
    }

    public Serialization getSerialization() {
        return this.serialization;
    }

    public Optional<Integer> getMaxDepth() {
        return this.maxDepth;
    }

    private static SerializationOptions fromJson(JsonInput input) {
        Serialization serialization = null;
        Optional<Integer> maxDepth = Optional.empty();
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "serialization": {
                    serialization = Serialization.fromString(input.nextString());
                    continue block8;
                }
                case "maxDepth": {
                    maxDepth = Optional.ofNullable(input.nextNumber().intValue());
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new SerializationOptions(serialization, maxDepth);
    }

    public static enum Serialization {
        DEEP("deep"),
        JSON("json"),
        IDONLY("idOnly");

        private String value;

        private Serialization(String value) {
            this.value = value;
        }

        public static Serialization fromString(String s) {
            return Arrays.stream(Serialization.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within Serialization "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Serialization fromJson(JsonInput input) {
            return Serialization.fromString(input.nextString());
        }
    }
}

