package org.openqa.selenium.devtools.v114.storage.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public class StorageBucketInfo {

    private final org.openqa.selenium.devtools.v114.storage.model.SerializedStorageKey storageKey;

    private final java.lang.String id;

    private final java.lang.String name;

    private final java.lang.Boolean isDefault;

    private final org.openqa.selenium.devtools.v114.network.model.TimeSinceEpoch expiration;

    private final java.lang.Number quota;

    private final java.lang.Boolean persistent;

    private final org.openqa.selenium.devtools.v114.storage.model.StorageBucketsDurability durability;

    public StorageBucketInfo(org.openqa.selenium.devtools.v114.storage.model.SerializedStorageKey storageKey, java.lang.String id, java.lang.String name, java.lang.Boolean isDefault, org.openqa.selenium.devtools.v114.network.model.TimeSinceEpoch expiration, java.lang.Number quota, java.lang.Boolean persistent, org.openqa.selenium.devtools.v114.storage.model.StorageBucketsDurability durability) {
        this.storageKey = java.util.Objects.requireNonNull(storageKey, "storageKey is required");
        this.id = java.util.Objects.requireNonNull(id, "id is required");
        this.name = java.util.Objects.requireNonNull(name, "name is required");
        this.isDefault = java.util.Objects.requireNonNull(isDefault, "isDefault is required");
        this.expiration = java.util.Objects.requireNonNull(expiration, "expiration is required");
        this.quota = java.util.Objects.requireNonNull(quota, "quota is required");
        this.persistent = java.util.Objects.requireNonNull(persistent, "persistent is required");
        this.durability = java.util.Objects.requireNonNull(durability, "durability is required");
    }

    public org.openqa.selenium.devtools.v114.storage.model.SerializedStorageKey getStorageKey() {
        return storageKey;
    }

    public java.lang.String getId() {
        return id;
    }

    public java.lang.String getName() {
        return name;
    }

    public java.lang.Boolean getIsDefault() {
        return isDefault;
    }

    public org.openqa.selenium.devtools.v114.network.model.TimeSinceEpoch getExpiration() {
        return expiration;
    }

    /**
     * Storage quota (bytes).
     */
    public java.lang.Number getQuota() {
        return quota;
    }

    public java.lang.Boolean getPersistent() {
        return persistent;
    }

    public org.openqa.selenium.devtools.v114.storage.model.StorageBucketsDurability getDurability() {
        return durability;
    }

    private static StorageBucketInfo fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v114.storage.model.SerializedStorageKey storageKey = null;
        java.lang.String id = null;
        java.lang.String name = null;
        java.lang.Boolean isDefault = false;
        org.openqa.selenium.devtools.v114.network.model.TimeSinceEpoch expiration = null;
        java.lang.Number quota = 0;
        java.lang.Boolean persistent = false;
        org.openqa.selenium.devtools.v114.storage.model.StorageBucketsDurability durability = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "storageKey":
                    storageKey = input.read(org.openqa.selenium.devtools.v114.storage.model.SerializedStorageKey.class);
                    break;
                case "id":
                    id = input.nextString();
                    break;
                case "name":
                    name = input.nextString();
                    break;
                case "isDefault":
                    isDefault = input.nextBoolean();
                    break;
                case "expiration":
                    expiration = input.read(org.openqa.selenium.devtools.v114.network.model.TimeSinceEpoch.class);
                    break;
                case "quota":
                    quota = input.nextNumber();
                    break;
                case "persistent":
                    persistent = input.nextBoolean();
                    break;
                case "durability":
                    durability = input.read(org.openqa.selenium.devtools.v114.storage.model.StorageBucketsDurability.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new StorageBucketInfo(storageKey, id, name, isDefault, expiration, quota, persistent, durability);
    }
}
