/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v113.database.model;

import java.util.Objects;
import org.openqa.selenium.devtools.v113.database.model.DatabaseId;
import org.openqa.selenium.json.JsonInput;

public class Database {
    private final DatabaseId id;
    private final String domain;
    private final String name;
    private final String version;

    public Database(DatabaseId id, String domain, String name, String version) {
        this.id = Objects.requireNonNull(id, "id is required");
        this.domain = Objects.requireNonNull(domain, "domain is required");
        this.name = Objects.requireNonNull(name, "name is required");
        this.version = Objects.requireNonNull(version, "version is required");
    }

    public DatabaseId getId() {
        return this.id;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    private static Database fromJson(JsonInput input) {
        DatabaseId id = null;
        String domain = null;
        String name = null;
        String version = null;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "id": {
                    id = (DatabaseId)input.read(DatabaseId.class);
                    continue block12;
                }
                case "domain": {
                    domain = input.nextString();
                    continue block12;
                }
                case "name": {
                    name = input.nextString();
                    continue block12;
                }
                case "version": {
                    version = input.nextString();
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Database(id, domain, name, version);
    }
}

