package org.openqa.selenium.devtools.v113.dom.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Document compatibility mode.
 */
public enum CompatibilityMode {

    QUIRKSMODE("QuirksMode"), LIMITEDQUIRKSMODE("LimitedQuirksMode"), NOQUIRKSMODE("NoQuirksMode");

    private String value;

    CompatibilityMode(String value) {
        this.value = value;
    }

    public static CompatibilityMode fromString(String s) {
        return java.util.Arrays.stream(CompatibilityMode.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within CompatibilityMode "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static CompatibilityMode fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
