/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v113.debugger.model;

import com.google.common.reflect.TypeToken;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.v113.debugger.model.CallFrame;
import org.openqa.selenium.devtools.v113.runtime.model.StackTrace;
import org.openqa.selenium.devtools.v113.runtime.model.StackTraceId;
import org.openqa.selenium.json.JsonInput;

public class Paused {
    private final List<CallFrame> callFrames;
    private final Reason reason;
    private final Optional<Map<String, Object>> data;
    private final Optional<List<String>> hitBreakpoints;
    private final Optional<StackTrace> asyncStackTrace;
    private final Optional<StackTraceId> asyncStackTraceId;
    private final Optional<StackTraceId> asyncCallStackTraceId;

    public Paused(List<CallFrame> callFrames, Reason reason, Optional<Map<String, Object>> data, Optional<List<String>> hitBreakpoints, Optional<StackTrace> asyncStackTrace, Optional<StackTraceId> asyncStackTraceId, Optional<StackTraceId> asyncCallStackTraceId) {
        this.callFrames = Objects.requireNonNull(callFrames, "callFrames is required");
        this.reason = Objects.requireNonNull(reason, "reason is required");
        this.data = data;
        this.hitBreakpoints = hitBreakpoints;
        this.asyncStackTrace = asyncStackTrace;
        this.asyncStackTraceId = asyncStackTraceId;
        this.asyncCallStackTraceId = asyncCallStackTraceId;
    }

    public List<CallFrame> getCallFrames() {
        return this.callFrames;
    }

    public Reason getReason() {
        return this.reason;
    }

    public Optional<Map<String, Object>> getData() {
        return this.data;
    }

    public Optional<List<String>> getHitBreakpoints() {
        return this.hitBreakpoints;
    }

    public Optional<StackTrace> getAsyncStackTrace() {
        return this.asyncStackTrace;
    }

    @Beta
    public Optional<StackTraceId> getAsyncStackTraceId() {
        return this.asyncStackTraceId;
    }

    @Beta
    @Deprecated
    public Optional<StackTraceId> getAsyncCallStackTraceId() {
        return this.asyncCallStackTraceId;
    }

    private static Paused fromJson(JsonInput input) {
        List callFrames = null;
        Reason reason = null;
        Optional<Map<String, Object>> data = Optional.empty();
        Optional<List<String>> hitBreakpoints = Optional.empty();
        Optional<StackTrace> asyncStackTrace = Optional.empty();
        Optional<StackTraceId> asyncStackTraceId = Optional.empty();
        Optional<StackTraceId> asyncCallStackTraceId = Optional.empty();
        input.beginObject();
        block18: while (input.hasNext()) {
            switch (input.nextName()) {
                case "callFrames": {
                    callFrames = (List)input.read(new TypeToken<List<CallFrame>>(){}.getType());
                    continue block18;
                }
                case "reason": {
                    reason = Reason.fromString(input.nextString());
                    continue block18;
                }
                case "data": {
                    data = Optional.ofNullable((Map)input.read(new TypeToken<Map<String, Object>>(){}.getType()));
                    continue block18;
                }
                case "hitBreakpoints": {
                    hitBreakpoints = Optional.ofNullable((List)input.read(new TypeToken<List<String>>(){}.getType()));
                    continue block18;
                }
                case "asyncStackTrace": {
                    asyncStackTrace = Optional.ofNullable((StackTrace)input.read(StackTrace.class));
                    continue block18;
                }
                case "asyncStackTraceId": {
                    asyncStackTraceId = Optional.ofNullable((StackTraceId)input.read(StackTraceId.class));
                    continue block18;
                }
                case "asyncCallStackTraceId": {
                    asyncCallStackTraceId = Optional.ofNullable((StackTraceId)input.read(StackTraceId.class));
                    continue block18;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Paused(callFrames, reason, data, hitBreakpoints, asyncStackTrace, asyncStackTraceId, asyncCallStackTraceId);
    }

    public static enum Reason {
        AMBIGUOUS("ambiguous"),
        ASSERT("assert"),
        CSPVIOLATION("CSPViolation"),
        DEBUGCOMMAND("debugCommand"),
        DOM("DOM"),
        EVENTLISTENER("EventListener"),
        EXCEPTION("exception"),
        INSTRUMENTATION("instrumentation"),
        OOM("OOM"),
        OTHER("other"),
        PROMISEREJECTION("promiseRejection"),
        XHR("XHR");

        private String value;

        private Reason(String value) {
            this.value = value;
        }

        public static Reason fromString(String s) {
            return Arrays.stream(Reason.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within Reason "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Reason fromJson(JsonInput input) {
            return Reason.fromString(input.nextString());
        }
    }
}

