/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v111.page;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v111.debugger.model.SearchMatch;
import org.openqa.selenium.devtools.v111.dom.model.Rect;
import org.openqa.selenium.devtools.v111.emulation.model.ScreenOrientation;
import org.openqa.selenium.devtools.v111.io.model.StreamHandle;
import org.openqa.selenium.devtools.v111.network.model.Cookie;
import org.openqa.selenium.devtools.v111.network.model.LoaderId;
import org.openqa.selenium.devtools.v111.network.model.MonotonicTime;
import org.openqa.selenium.devtools.v111.page.model.AdScriptId;
import org.openqa.selenium.devtools.v111.page.model.AppManifestError;
import org.openqa.selenium.devtools.v111.page.model.AppManifestParsedProperties;
import org.openqa.selenium.devtools.v111.page.model.BackForwardCacheNotUsed;
import org.openqa.selenium.devtools.v111.page.model.CompilationCacheParams;
import org.openqa.selenium.devtools.v111.page.model.CompilationCacheProduced;
import org.openqa.selenium.devtools.v111.page.model.DownloadProgress;
import org.openqa.selenium.devtools.v111.page.model.DownloadWillBegin;
import org.openqa.selenium.devtools.v111.page.model.FileChooserOpened;
import org.openqa.selenium.devtools.v111.page.model.FontFamilies;
import org.openqa.selenium.devtools.v111.page.model.FontSizes;
import org.openqa.selenium.devtools.v111.page.model.Frame;
import org.openqa.selenium.devtools.v111.page.model.FrameAttached;
import org.openqa.selenium.devtools.v111.page.model.FrameDetached;
import org.openqa.selenium.devtools.v111.page.model.FrameId;
import org.openqa.selenium.devtools.v111.page.model.FrameNavigated;
import org.openqa.selenium.devtools.v111.page.model.FrameRequestedNavigation;
import org.openqa.selenium.devtools.v111.page.model.FrameResourceTree;
import org.openqa.selenium.devtools.v111.page.model.FrameScheduledNavigation;
import org.openqa.selenium.devtools.v111.page.model.FrameTree;
import org.openqa.selenium.devtools.v111.page.model.InstallabilityError;
import org.openqa.selenium.devtools.v111.page.model.JavascriptDialogClosed;
import org.openqa.selenium.devtools.v111.page.model.JavascriptDialogOpening;
import org.openqa.selenium.devtools.v111.page.model.LayoutViewport;
import org.openqa.selenium.devtools.v111.page.model.LifecycleEvent;
import org.openqa.selenium.devtools.v111.page.model.NavigatedWithinDocument;
import org.openqa.selenium.devtools.v111.page.model.NavigationEntry;
import org.openqa.selenium.devtools.v111.page.model.OriginTrial;
import org.openqa.selenium.devtools.v111.page.model.PermissionsPolicyFeatureState;
import org.openqa.selenium.devtools.v111.page.model.PrerenderAttemptCompleted;
import org.openqa.selenium.devtools.v111.page.model.ReferrerPolicy;
import org.openqa.selenium.devtools.v111.page.model.ScreencastFrame;
import org.openqa.selenium.devtools.v111.page.model.ScriptFontFamilies;
import org.openqa.selenium.devtools.v111.page.model.ScriptIdentifier;
import org.openqa.selenium.devtools.v111.page.model.TransitionType;
import org.openqa.selenium.devtools.v111.page.model.Viewport;
import org.openqa.selenium.devtools.v111.page.model.VisualViewport;
import org.openqa.selenium.devtools.v111.page.model.WindowOpen;
import org.openqa.selenium.devtools.v111.runtime.model.ExecutionContextId;
import org.openqa.selenium.json.JsonInput;

public class Page {
    @Beta
    @Deprecated
    public static Command<ScriptIdentifier> addScriptToEvaluateOnLoad(String scriptSource) {
        Objects.requireNonNull(scriptSource, "scriptSource is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"scriptSource", (Object)scriptSource);
        return new Command("Page.addScriptToEvaluateOnLoad", (Map)params.build(), ConverterFunctions.map((String)"identifier", ScriptIdentifier.class));
    }

    public static Command<ScriptIdentifier> addScriptToEvaluateOnNewDocument(String source, Optional<String> worldName, Optional<Boolean> includeCommandLineAPI) {
        Objects.requireNonNull(source, "source is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"source", (Object)source);
        worldName.ifPresent(p -> params.put((Object)"worldName", p));
        includeCommandLineAPI.ifPresent(p -> params.put((Object)"includeCommandLineAPI", p));
        return new Command("Page.addScriptToEvaluateOnNewDocument", (Map)params.build(), ConverterFunctions.map((String)"identifier", ScriptIdentifier.class));
    }

    public static Command<Void> bringToFront() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Page.bringToFront", (Map)params.build());
    }

    public static Command<String> captureScreenshot(Optional<CaptureScreenshotFormat> format, Optional<Integer> quality, Optional<Viewport> clip, Optional<Boolean> fromSurface, Optional<Boolean> captureBeyondViewport, Optional<Boolean> optimizeForSpeed) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        format.ifPresent(p -> params.put((Object)"format", (Object)p));
        quality.ifPresent(p -> params.put((Object)"quality", p));
        clip.ifPresent(p -> params.put((Object)"clip", p));
        fromSurface.ifPresent(p -> params.put((Object)"fromSurface", p));
        captureBeyondViewport.ifPresent(p -> params.put((Object)"captureBeyondViewport", p));
        optimizeForSpeed.ifPresent(p -> params.put((Object)"optimizeForSpeed", p));
        return new Command("Page.captureScreenshot", (Map)params.build(), ConverterFunctions.map((String)"data", String.class));
    }

    @Beta
    public static Command<String> captureSnapshot(Optional<CaptureSnapshotFormat> format) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        format.ifPresent(p -> params.put((Object)"format", (Object)p));
        return new Command("Page.captureSnapshot", (Map)params.build(), ConverterFunctions.map((String)"data", String.class));
    }

    @Beta
    @Deprecated
    public static Command<Void> clearDeviceMetricsOverride() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Page.clearDeviceMetricsOverride", (Map)params.build());
    }

    @Beta
    @Deprecated
    public static Command<Void> clearDeviceOrientationOverride() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Page.clearDeviceOrientationOverride", (Map)params.build());
    }

    @Deprecated
    public static Command<Void> clearGeolocationOverride() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Page.clearGeolocationOverride", (Map)params.build());
    }

    public static Command<ExecutionContextId> createIsolatedWorld(FrameId frameId, Optional<String> worldName, Optional<Boolean> grantUniveralAccess) {
        Objects.requireNonNull(frameId, "frameId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"frameId", (Object)frameId);
        worldName.ifPresent(p -> params.put((Object)"worldName", p));
        grantUniveralAccess.ifPresent(p -> params.put((Object)"grantUniveralAccess", p));
        return new Command("Page.createIsolatedWorld", (Map)params.build(), ConverterFunctions.map((String)"executionContextId", ExecutionContextId.class));
    }

    @Beta
    @Deprecated
    public static Command<Void> deleteCookie(String cookieName, String url) {
        Objects.requireNonNull(cookieName, "cookieName is required");
        Objects.requireNonNull(url, "url is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"cookieName", (Object)cookieName);
        params.put((Object)"url", (Object)url);
        return new Command("Page.deleteCookie", (Map)params.build());
    }

    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Page.disable", (Map)params.build());
    }

    public static Command<Void> enable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Page.enable", (Map)params.build());
    }

    public static Command<GetAppManifestResponse> getAppManifest() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Page.getAppManifest", (Map)params.build(), input -> (GetAppManifestResponse)input.read(GetAppManifestResponse.class));
    }

    @Beta
    public static Command<List<InstallabilityError>> getInstallabilityErrors() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Page.getInstallabilityErrors", (Map)params.build(), ConverterFunctions.map((String)"installabilityErrors", (Type)new TypeToken<List<InstallabilityError>>(){}.getType()));
    }

    @Beta
    public static Command<String> getManifestIcons() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Page.getManifestIcons", (Map)params.build(), ConverterFunctions.map((String)"primaryIcon", String.class));
    }

    @Beta
    public static Command<GetAppIdResponse> getAppId() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Page.getAppId", (Map)params.build(), input -> (GetAppIdResponse)input.read(GetAppIdResponse.class));
    }

    @Beta
    public static Command<AdScriptId> getAdScriptId(FrameId frameId) {
        Objects.requireNonNull(frameId, "frameId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"frameId", (Object)frameId);
        return new Command("Page.getAdScriptId", (Map)params.build(), ConverterFunctions.map((String)"adScriptId", AdScriptId.class));
    }

    @Beta
    @Deprecated
    public static Command<List<Cookie>> getCookies() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Page.getCookies", (Map)params.build(), ConverterFunctions.map((String)"cookies", (Type)new TypeToken<List<Cookie>>(){}.getType()));
    }

    public static Command<FrameTree> getFrameTree() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Page.getFrameTree", (Map)params.build(), ConverterFunctions.map((String)"frameTree", FrameTree.class));
    }

    public static Command<GetLayoutMetricsResponse> getLayoutMetrics() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Page.getLayoutMetrics", (Map)params.build(), input -> (GetLayoutMetricsResponse)input.read(GetLayoutMetricsResponse.class));
    }

    public static Command<GetNavigationHistoryResponse> getNavigationHistory() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Page.getNavigationHistory", (Map)params.build(), input -> (GetNavigationHistoryResponse)input.read(GetNavigationHistoryResponse.class));
    }

    public static Command<Void> resetNavigationHistory() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Page.resetNavigationHistory", (Map)params.build());
    }

    @Beta
    public static Command<GetResourceContentResponse> getResourceContent(FrameId frameId, String url) {
        Objects.requireNonNull(frameId, "frameId is required");
        Objects.requireNonNull(url, "url is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"frameId", (Object)frameId);
        params.put((Object)"url", (Object)url);
        return new Command("Page.getResourceContent", (Map)params.build(), input -> (GetResourceContentResponse)input.read(GetResourceContentResponse.class));
    }

    @Beta
    public static Command<FrameResourceTree> getResourceTree() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Page.getResourceTree", (Map)params.build(), ConverterFunctions.map((String)"frameTree", FrameResourceTree.class));
    }

    public static Command<Void> handleJavaScriptDialog(Boolean accept, Optional<String> promptText) {
        Objects.requireNonNull(accept, "accept is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"accept", (Object)accept);
        promptText.ifPresent(p -> params.put((Object)"promptText", p));
        return new Command("Page.handleJavaScriptDialog", (Map)params.build());
    }

    public static Command<NavigateResponse> navigate(String url, Optional<String> referrer, Optional<TransitionType> transitionType, Optional<FrameId> frameId, Optional<ReferrerPolicy> referrerPolicy) {
        Objects.requireNonNull(url, "url is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"url", (Object)url);
        referrer.ifPresent(p -> params.put((Object)"referrer", p));
        transitionType.ifPresent(p -> params.put((Object)"transitionType", (Object)p));
        frameId.ifPresent(p -> params.put((Object)"frameId", p));
        referrerPolicy.ifPresent(p -> params.put((Object)"referrerPolicy", (Object)p));
        return new Command("Page.navigate", (Map)params.build(), input -> (NavigateResponse)input.read(NavigateResponse.class));
    }

    public static Command<Void> navigateToHistoryEntry(Integer entryId) {
        Objects.requireNonNull(entryId, "entryId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"entryId", (Object)entryId);
        return new Command("Page.navigateToHistoryEntry", (Map)params.build());
    }

    public static Command<PrintToPDFResponse> printToPDF(Optional<Boolean> landscape, Optional<Boolean> displayHeaderFooter, Optional<Boolean> printBackground, Optional<Number> scale, Optional<Number> paperWidth, Optional<Number> paperHeight, Optional<Number> marginTop, Optional<Number> marginBottom, Optional<Number> marginLeft, Optional<Number> marginRight, Optional<String> pageRanges, Optional<String> headerTemplate, Optional<String> footerTemplate, Optional<Boolean> preferCSSPageSize, Optional<PrintToPDFTransferMode> transferMode) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        landscape.ifPresent(p -> params.put((Object)"landscape", p));
        displayHeaderFooter.ifPresent(p -> params.put((Object)"displayHeaderFooter", p));
        printBackground.ifPresent(p -> params.put((Object)"printBackground", p));
        scale.ifPresent(p -> params.put((Object)"scale", p));
        paperWidth.ifPresent(p -> params.put((Object)"paperWidth", p));
        paperHeight.ifPresent(p -> params.put((Object)"paperHeight", p));
        marginTop.ifPresent(p -> params.put((Object)"marginTop", p));
        marginBottom.ifPresent(p -> params.put((Object)"marginBottom", p));
        marginLeft.ifPresent(p -> params.put((Object)"marginLeft", p));
        marginRight.ifPresent(p -> params.put((Object)"marginRight", p));
        pageRanges.ifPresent(p -> params.put((Object)"pageRanges", p));
        headerTemplate.ifPresent(p -> params.put((Object)"headerTemplate", p));
        footerTemplate.ifPresent(p -> params.put((Object)"footerTemplate", p));
        preferCSSPageSize.ifPresent(p -> params.put((Object)"preferCSSPageSize", p));
        transferMode.ifPresent(p -> params.put((Object)"transferMode", (Object)p));
        return new Command("Page.printToPDF", (Map)params.build(), input -> (PrintToPDFResponse)input.read(PrintToPDFResponse.class));
    }

    public static Command<Void> reload(Optional<Boolean> ignoreCache, Optional<String> scriptToEvaluateOnLoad) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        ignoreCache.ifPresent(p -> params.put((Object)"ignoreCache", p));
        scriptToEvaluateOnLoad.ifPresent(p -> params.put((Object)"scriptToEvaluateOnLoad", p));
        return new Command("Page.reload", (Map)params.build());
    }

    @Beta
    @Deprecated
    public static Command<Void> removeScriptToEvaluateOnLoad(ScriptIdentifier identifier) {
        Objects.requireNonNull(identifier, "identifier is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"identifier", (Object)identifier);
        return new Command("Page.removeScriptToEvaluateOnLoad", (Map)params.build());
    }

    public static Command<Void> removeScriptToEvaluateOnNewDocument(ScriptIdentifier identifier) {
        Objects.requireNonNull(identifier, "identifier is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"identifier", (Object)identifier);
        return new Command("Page.removeScriptToEvaluateOnNewDocument", (Map)params.build());
    }

    @Beta
    public static Command<Void> screencastFrameAck(Integer sessionId) {
        Objects.requireNonNull(sessionId, "sessionId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"sessionId", (Object)sessionId);
        return new Command("Page.screencastFrameAck", (Map)params.build());
    }

    @Beta
    public static Command<List<SearchMatch>> searchInResource(FrameId frameId, String url, String query, Optional<Boolean> caseSensitive, Optional<Boolean> isRegex) {
        Objects.requireNonNull(frameId, "frameId is required");
        Objects.requireNonNull(url, "url is required");
        Objects.requireNonNull(query, "query is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"frameId", (Object)frameId);
        params.put((Object)"url", (Object)url);
        params.put((Object)"query", (Object)query);
        caseSensitive.ifPresent(p -> params.put((Object)"caseSensitive", p));
        isRegex.ifPresent(p -> params.put((Object)"isRegex", p));
        return new Command("Page.searchInResource", (Map)params.build(), ConverterFunctions.map((String)"result", (Type)new TypeToken<List<SearchMatch>>(){}.getType()));
    }

    @Beta
    public static Command<Void> setAdBlockingEnabled(Boolean enabled) {
        Objects.requireNonNull(enabled, "enabled is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"enabled", (Object)enabled);
        return new Command("Page.setAdBlockingEnabled", (Map)params.build());
    }

    @Beta
    public static Command<Void> setBypassCSP(Boolean enabled) {
        Objects.requireNonNull(enabled, "enabled is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"enabled", (Object)enabled);
        return new Command("Page.setBypassCSP", (Map)params.build());
    }

    @Beta
    public static Command<List<PermissionsPolicyFeatureState>> getPermissionsPolicyState(FrameId frameId) {
        Objects.requireNonNull(frameId, "frameId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"frameId", (Object)frameId);
        return new Command("Page.getPermissionsPolicyState", (Map)params.build(), ConverterFunctions.map((String)"states", (Type)new TypeToken<List<PermissionsPolicyFeatureState>>(){}.getType()));
    }

    @Beta
    public static Command<List<OriginTrial>> getOriginTrials(FrameId frameId) {
        Objects.requireNonNull(frameId, "frameId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"frameId", (Object)frameId);
        return new Command("Page.getOriginTrials", (Map)params.build(), ConverterFunctions.map((String)"originTrials", (Type)new TypeToken<List<OriginTrial>>(){}.getType()));
    }

    @Beta
    @Deprecated
    public static Command<Void> setDeviceMetricsOverride(Integer width, Integer height, Number deviceScaleFactor, Boolean mobile, Optional<Number> scale, Optional<Integer> screenWidth, Optional<Integer> screenHeight, Optional<Integer> positionX, Optional<Integer> positionY, Optional<Boolean> dontSetVisibleSize, Optional<ScreenOrientation> screenOrientation, Optional<Viewport> viewport) {
        Objects.requireNonNull(width, "width is required");
        Objects.requireNonNull(height, "height is required");
        Objects.requireNonNull(deviceScaleFactor, "deviceScaleFactor is required");
        Objects.requireNonNull(mobile, "mobile is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"width", (Object)width);
        params.put((Object)"height", (Object)height);
        params.put((Object)"deviceScaleFactor", (Object)deviceScaleFactor);
        params.put((Object)"mobile", (Object)mobile);
        scale.ifPresent(p -> params.put((Object)"scale", p));
        screenWidth.ifPresent(p -> params.put((Object)"screenWidth", p));
        screenHeight.ifPresent(p -> params.put((Object)"screenHeight", p));
        positionX.ifPresent(p -> params.put((Object)"positionX", p));
        positionY.ifPresent(p -> params.put((Object)"positionY", p));
        dontSetVisibleSize.ifPresent(p -> params.put((Object)"dontSetVisibleSize", p));
        screenOrientation.ifPresent(p -> params.put((Object)"screenOrientation", p));
        viewport.ifPresent(p -> params.put((Object)"viewport", p));
        return new Command("Page.setDeviceMetricsOverride", (Map)params.build());
    }

    @Beta
    @Deprecated
    public static Command<Void> setDeviceOrientationOverride(Number alpha, Number beta, Number gamma) {
        Objects.requireNonNull(alpha, "alpha is required");
        Objects.requireNonNull(beta, "beta is required");
        Objects.requireNonNull(gamma, "gamma is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"alpha", (Object)alpha);
        params.put((Object)"beta", (Object)beta);
        params.put((Object)"gamma", (Object)gamma);
        return new Command("Page.setDeviceOrientationOverride", (Map)params.build());
    }

    @Beta
    public static Command<Void> setFontFamilies(FontFamilies fontFamilies, Optional<List<ScriptFontFamilies>> forScripts) {
        Objects.requireNonNull(fontFamilies, "fontFamilies is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"fontFamilies", (Object)fontFamilies);
        forScripts.ifPresent(p -> params.put((Object)"forScripts", p));
        return new Command("Page.setFontFamilies", (Map)params.build());
    }

    @Beta
    public static Command<Void> setFontSizes(FontSizes fontSizes) {
        Objects.requireNonNull(fontSizes, "fontSizes is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"fontSizes", (Object)fontSizes);
        return new Command("Page.setFontSizes", (Map)params.build());
    }

    public static Command<Void> setDocumentContent(FrameId frameId, String html) {
        Objects.requireNonNull(frameId, "frameId is required");
        Objects.requireNonNull(html, "html is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"frameId", (Object)frameId);
        params.put((Object)"html", (Object)html);
        return new Command("Page.setDocumentContent", (Map)params.build());
    }

    @Beta
    @Deprecated
    public static Command<Void> setDownloadBehavior(SetDownloadBehaviorBehavior behavior, Optional<String> downloadPath) {
        Objects.requireNonNull(behavior, "behavior is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"behavior", (Object)behavior);
        downloadPath.ifPresent(p -> params.put((Object)"downloadPath", p));
        return new Command("Page.setDownloadBehavior", (Map)params.build());
    }

    @Deprecated
    public static Command<Void> setGeolocationOverride(Optional<Number> latitude, Optional<Number> longitude, Optional<Number> accuracy) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        latitude.ifPresent(p -> params.put((Object)"latitude", p));
        longitude.ifPresent(p -> params.put((Object)"longitude", p));
        accuracy.ifPresent(p -> params.put((Object)"accuracy", p));
        return new Command("Page.setGeolocationOverride", (Map)params.build());
    }

    @Beta
    public static Command<Void> setLifecycleEventsEnabled(Boolean enabled) {
        Objects.requireNonNull(enabled, "enabled is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"enabled", (Object)enabled);
        return new Command("Page.setLifecycleEventsEnabled", (Map)params.build());
    }

    @Beta
    @Deprecated
    public static Command<Void> setTouchEmulationEnabled(Boolean enabled, Optional<SetTouchEmulationEnabledConfiguration> configuration) {
        Objects.requireNonNull(enabled, "enabled is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"enabled", (Object)enabled);
        configuration.ifPresent(p -> params.put((Object)"configuration", (Object)p));
        return new Command("Page.setTouchEmulationEnabled", (Map)params.build());
    }

    @Beta
    public static Command<Void> startScreencast(Optional<StartScreencastFormat> format, Optional<Integer> quality, Optional<Integer> maxWidth, Optional<Integer> maxHeight, Optional<Integer> everyNthFrame) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        format.ifPresent(p -> params.put((Object)"format", (Object)p));
        quality.ifPresent(p -> params.put((Object)"quality", p));
        maxWidth.ifPresent(p -> params.put((Object)"maxWidth", p));
        maxHeight.ifPresent(p -> params.put((Object)"maxHeight", p));
        everyNthFrame.ifPresent(p -> params.put((Object)"everyNthFrame", p));
        return new Command("Page.startScreencast", (Map)params.build());
    }

    public static Command<Void> stopLoading() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Page.stopLoading", (Map)params.build());
    }

    @Beta
    public static Command<Void> crash() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Page.crash", (Map)params.build());
    }

    @Beta
    public static Command<Void> close() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Page.close", (Map)params.build());
    }

    @Beta
    public static Command<Void> setWebLifecycleState(SetWebLifecycleStateState state) {
        Objects.requireNonNull(state, "state is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"state", (Object)state);
        return new Command("Page.setWebLifecycleState", (Map)params.build());
    }

    @Beta
    public static Command<Void> stopScreencast() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Page.stopScreencast", (Map)params.build());
    }

    @Beta
    public static Command<Void> produceCompilationCache(List<CompilationCacheParams> scripts) {
        Objects.requireNonNull(scripts, "scripts is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"scripts", scripts);
        return new Command("Page.produceCompilationCache", (Map)params.build());
    }

    @Beta
    public static Command<Void> addCompilationCache(String url, String data) {
        Objects.requireNonNull(url, "url is required");
        Objects.requireNonNull(data, "data is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"url", (Object)url);
        params.put((Object)"data", (Object)data);
        return new Command("Page.addCompilationCache", (Map)params.build());
    }

    @Beta
    public static Command<Void> clearCompilationCache() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Page.clearCompilationCache", (Map)params.build());
    }

    @Beta
    public static Command<Void> setSPCTransactionMode(SetSPCTransactionModeMode mode) {
        Objects.requireNonNull(mode, "mode is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"mode", (Object)mode);
        return new Command("Page.setSPCTransactionMode", (Map)params.build());
    }

    @Beta
    public static Command<Void> generateTestReport(String message, Optional<String> group) {
        Objects.requireNonNull(message, "message is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"message", (Object)message);
        group.ifPresent(p -> params.put((Object)"group", p));
        return new Command("Page.generateTestReport", (Map)params.build());
    }

    @Beta
    public static Command<Void> waitForDebugger() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Page.waitForDebugger", (Map)params.build());
    }

    @Beta
    public static Command<Void> setInterceptFileChooserDialog(Boolean enabled) {
        Objects.requireNonNull(enabled, "enabled is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"enabled", (Object)enabled);
        return new Command("Page.setInterceptFileChooserDialog", (Map)params.build());
    }

    public static Event<MonotonicTime> domContentEventFired() {
        return new Event("Page.domContentEventFired", ConverterFunctions.map((String)"timestamp", MonotonicTime.class));
    }

    public static Event<FileChooserOpened> fileChooserOpened() {
        return new Event("Page.fileChooserOpened", input -> (FileChooserOpened)input.read(FileChooserOpened.class));
    }

    public static Event<FrameAttached> frameAttached() {
        return new Event("Page.frameAttached", input -> (FrameAttached)input.read(FrameAttached.class));
    }

    public static Event<FrameId> frameClearedScheduledNavigation() {
        return new Event("Page.frameClearedScheduledNavigation", ConverterFunctions.map((String)"frameId", FrameId.class));
    }

    public static Event<FrameDetached> frameDetached() {
        return new Event("Page.frameDetached", input -> (FrameDetached)input.read(FrameDetached.class));
    }

    public static Event<FrameNavigated> frameNavigated() {
        return new Event("Page.frameNavigated", input -> (FrameNavigated)input.read(FrameNavigated.class));
    }

    public static Event<Frame> documentOpened() {
        return new Event("Page.documentOpened", ConverterFunctions.map((String)"frame", Frame.class));
    }

    public static Event<Void> frameResized() {
        return new Event("Page.frameResized", input -> null);
    }

    public static Event<FrameRequestedNavigation> frameRequestedNavigation() {
        return new Event("Page.frameRequestedNavigation", input -> (FrameRequestedNavigation)input.read(FrameRequestedNavigation.class));
    }

    public static Event<FrameScheduledNavigation> frameScheduledNavigation() {
        return new Event("Page.frameScheduledNavigation", input -> (FrameScheduledNavigation)input.read(FrameScheduledNavigation.class));
    }

    public static Event<FrameId> frameStartedLoading() {
        return new Event("Page.frameStartedLoading", ConverterFunctions.map((String)"frameId", FrameId.class));
    }

    public static Event<FrameId> frameStoppedLoading() {
        return new Event("Page.frameStoppedLoading", ConverterFunctions.map((String)"frameId", FrameId.class));
    }

    public static Event<DownloadWillBegin> downloadWillBegin() {
        return new Event("Page.downloadWillBegin", input -> (DownloadWillBegin)input.read(DownloadWillBegin.class));
    }

    public static Event<DownloadProgress> downloadProgress() {
        return new Event("Page.downloadProgress", input -> (DownloadProgress)input.read(DownloadProgress.class));
    }

    public static Event<Void> interstitialHidden() {
        return new Event("Page.interstitialHidden", input -> null);
    }

    public static Event<Void> interstitialShown() {
        return new Event("Page.interstitialShown", input -> null);
    }

    public static Event<JavascriptDialogClosed> javascriptDialogClosed() {
        return new Event("Page.javascriptDialogClosed", input -> (JavascriptDialogClosed)input.read(JavascriptDialogClosed.class));
    }

    public static Event<JavascriptDialogOpening> javascriptDialogOpening() {
        return new Event("Page.javascriptDialogOpening", input -> (JavascriptDialogOpening)input.read(JavascriptDialogOpening.class));
    }

    public static Event<LifecycleEvent> lifecycleEvent() {
        return new Event("Page.lifecycleEvent", input -> (LifecycleEvent)input.read(LifecycleEvent.class));
    }

    public static Event<BackForwardCacheNotUsed> backForwardCacheNotUsed() {
        return new Event("Page.backForwardCacheNotUsed", input -> (BackForwardCacheNotUsed)input.read(BackForwardCacheNotUsed.class));
    }

    public static Event<PrerenderAttemptCompleted> prerenderAttemptCompleted() {
        return new Event("Page.prerenderAttemptCompleted", input -> (PrerenderAttemptCompleted)input.read(PrerenderAttemptCompleted.class));
    }

    public static Event<MonotonicTime> loadEventFired() {
        return new Event("Page.loadEventFired", ConverterFunctions.map((String)"timestamp", MonotonicTime.class));
    }

    public static Event<NavigatedWithinDocument> navigatedWithinDocument() {
        return new Event("Page.navigatedWithinDocument", input -> (NavigatedWithinDocument)input.read(NavigatedWithinDocument.class));
    }

    public static Event<ScreencastFrame> screencastFrame() {
        return new Event("Page.screencastFrame", input -> (ScreencastFrame)input.read(ScreencastFrame.class));
    }

    public static Event<Boolean> screencastVisibilityChanged() {
        return new Event("Page.screencastVisibilityChanged", ConverterFunctions.map((String)"visible", Boolean.class));
    }

    public static Event<WindowOpen> windowOpen() {
        return new Event("Page.windowOpen", input -> (WindowOpen)input.read(WindowOpen.class));
    }

    public static Event<CompilationCacheProduced> compilationCacheProduced() {
        return new Event("Page.compilationCacheProduced", input -> (CompilationCacheProduced)input.read(CompilationCacheProduced.class));
    }

    public static enum SetSPCTransactionModeMode {
        NONE("none"),
        AUTOACCEPT("autoAccept"),
        AUTOREJECT("autoReject"),
        AUTOOPTOUT("autoOptOut");

        private String value;

        private SetSPCTransactionModeMode(String value) {
            this.value = value;
        }

        public static SetSPCTransactionModeMode fromString(String s) {
            return Arrays.stream(SetSPCTransactionModeMode.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within SetSPCTransactionModeMode "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static SetSPCTransactionModeMode fromJson(JsonInput input) {
            return SetSPCTransactionModeMode.fromString(input.nextString());
        }
    }

    public static enum SetWebLifecycleStateState {
        FROZEN("frozen"),
        ACTIVE("active");

        private String value;

        private SetWebLifecycleStateState(String value) {
            this.value = value;
        }

        public static SetWebLifecycleStateState fromString(String s) {
            return Arrays.stream(SetWebLifecycleStateState.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within SetWebLifecycleStateState "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static SetWebLifecycleStateState fromJson(JsonInput input) {
            return SetWebLifecycleStateState.fromString(input.nextString());
        }
    }

    public static enum StartScreencastFormat {
        JPEG("jpeg"),
        PNG("png");

        private String value;

        private StartScreencastFormat(String value) {
            this.value = value;
        }

        public static StartScreencastFormat fromString(String s) {
            return Arrays.stream(StartScreencastFormat.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within StartScreencastFormat "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static StartScreencastFormat fromJson(JsonInput input) {
            return StartScreencastFormat.fromString(input.nextString());
        }
    }

    public static enum SetTouchEmulationEnabledConfiguration {
        MOBILE("mobile"),
        DESKTOP("desktop");

        private String value;

        private SetTouchEmulationEnabledConfiguration(String value) {
            this.value = value;
        }

        public static SetTouchEmulationEnabledConfiguration fromString(String s) {
            return Arrays.stream(SetTouchEmulationEnabledConfiguration.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within SetTouchEmulationEnabledConfiguration "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static SetTouchEmulationEnabledConfiguration fromJson(JsonInput input) {
            return SetTouchEmulationEnabledConfiguration.fromString(input.nextString());
        }
    }

    public static enum SetDownloadBehaviorBehavior {
        DENY("deny"),
        ALLOW("allow"),
        DEFAULT("default");

        private String value;

        private SetDownloadBehaviorBehavior(String value) {
            this.value = value;
        }

        public static SetDownloadBehaviorBehavior fromString(String s) {
            return Arrays.stream(SetDownloadBehaviorBehavior.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within SetDownloadBehaviorBehavior "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static SetDownloadBehaviorBehavior fromJson(JsonInput input) {
            return SetDownloadBehaviorBehavior.fromString(input.nextString());
        }
    }

    public static enum PrintToPDFTransferMode {
        RETURNASBASE64("ReturnAsBase64"),
        RETURNASSTREAM("ReturnAsStream");

        private String value;

        private PrintToPDFTransferMode(String value) {
            this.value = value;
        }

        public static PrintToPDFTransferMode fromString(String s) {
            return Arrays.stream(PrintToPDFTransferMode.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within PrintToPDFTransferMode "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static PrintToPDFTransferMode fromJson(JsonInput input) {
            return PrintToPDFTransferMode.fromString(input.nextString());
        }
    }

    public static class PrintToPDFResponse {
        private final String data;
        private final Optional<StreamHandle> stream;

        public PrintToPDFResponse(String data, Optional<StreamHandle> stream) {
            this.data = Objects.requireNonNull(data, "data is required");
            this.stream = stream;
        }

        public String getData() {
            return this.data;
        }

        public Optional<StreamHandle> getStream() {
            return this.stream;
        }

        private static PrintToPDFResponse fromJson(JsonInput input) {
            String data = null;
            Optional<StreamHandle> stream = Optional.empty();
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "data": {
                        data = input.nextString();
                        continue block8;
                    }
                    case "stream": {
                        stream = Optional.ofNullable((StreamHandle)input.read(StreamHandle.class));
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new PrintToPDFResponse(data, stream);
        }
    }

    public static class NavigateResponse {
        private final FrameId frameId;
        private final Optional<LoaderId> loaderId;
        private final Optional<String> errorText;

        public NavigateResponse(FrameId frameId, Optional<LoaderId> loaderId, Optional<String> errorText) {
            this.frameId = Objects.requireNonNull(frameId, "frameId is required");
            this.loaderId = loaderId;
            this.errorText = errorText;
        }

        public FrameId getFrameId() {
            return this.frameId;
        }

        public Optional<LoaderId> getLoaderId() {
            return this.loaderId;
        }

        public Optional<String> getErrorText() {
            return this.errorText;
        }

        private static NavigateResponse fromJson(JsonInput input) {
            FrameId frameId = null;
            Optional<LoaderId> loaderId = Optional.empty();
            Optional<String> errorText = Optional.empty();
            input.beginObject();
            block10: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "frameId": {
                        frameId = (FrameId)input.read(FrameId.class);
                        continue block10;
                    }
                    case "loaderId": {
                        loaderId = Optional.ofNullable((LoaderId)input.read(LoaderId.class));
                        continue block10;
                    }
                    case "errorText": {
                        errorText = Optional.ofNullable(input.nextString());
                        continue block10;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new NavigateResponse(frameId, loaderId, errorText);
        }
    }

    public static class GetResourceContentResponse {
        private final String content;
        private final Boolean base64Encoded;

        public GetResourceContentResponse(String content, Boolean base64Encoded) {
            this.content = Objects.requireNonNull(content, "content is required");
            this.base64Encoded = Objects.requireNonNull(base64Encoded, "base64Encoded is required");
        }

        public String getContent() {
            return this.content;
        }

        public Boolean getBase64Encoded() {
            return this.base64Encoded;
        }

        private static GetResourceContentResponse fromJson(JsonInput input) {
            String content = null;
            Boolean base64Encoded = false;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "content": {
                        content = input.nextString();
                        continue block8;
                    }
                    case "base64Encoded": {
                        base64Encoded = input.nextBoolean();
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetResourceContentResponse(content, base64Encoded);
        }
    }

    public static class GetNavigationHistoryResponse {
        private final Integer currentIndex;
        private final List<NavigationEntry> entries;

        public GetNavigationHistoryResponse(Integer currentIndex, List<NavigationEntry> entries) {
            this.currentIndex = Objects.requireNonNull(currentIndex, "currentIndex is required");
            this.entries = Objects.requireNonNull(entries, "entries is required");
        }

        public Integer getCurrentIndex() {
            return this.currentIndex;
        }

        public List<NavigationEntry> getEntries() {
            return this.entries;
        }

        private static GetNavigationHistoryResponse fromJson(JsonInput input) {
            Integer currentIndex = 0;
            List entries = null;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "currentIndex": {
                        currentIndex = input.nextNumber().intValue();
                        continue block8;
                    }
                    case "entries": {
                        entries = (List)input.read(new TypeToken<List<NavigationEntry>>(){}.getType());
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetNavigationHistoryResponse(currentIndex, entries);
        }
    }

    public static class GetLayoutMetricsResponse {
        private final LayoutViewport layoutViewport;
        private final VisualViewport visualViewport;
        private final Rect contentSize;
        private final LayoutViewport cssLayoutViewport;
        private final VisualViewport cssVisualViewport;
        private final Rect cssContentSize;

        public GetLayoutMetricsResponse(LayoutViewport layoutViewport, VisualViewport visualViewport, Rect contentSize, LayoutViewport cssLayoutViewport, VisualViewport cssVisualViewport, Rect cssContentSize) {
            this.layoutViewport = Objects.requireNonNull(layoutViewport, "layoutViewport is required");
            this.visualViewport = Objects.requireNonNull(visualViewport, "visualViewport is required");
            this.contentSize = Objects.requireNonNull(contentSize, "contentSize is required");
            this.cssLayoutViewport = Objects.requireNonNull(cssLayoutViewport, "cssLayoutViewport is required");
            this.cssVisualViewport = Objects.requireNonNull(cssVisualViewport, "cssVisualViewport is required");
            this.cssContentSize = Objects.requireNonNull(cssContentSize, "cssContentSize is required");
        }

        public LayoutViewport getLayoutViewport() {
            return this.layoutViewport;
        }

        public VisualViewport getVisualViewport() {
            return this.visualViewport;
        }

        public Rect getContentSize() {
            return this.contentSize;
        }

        public LayoutViewport getCssLayoutViewport() {
            return this.cssLayoutViewport;
        }

        public VisualViewport getCssVisualViewport() {
            return this.cssVisualViewport;
        }

        public Rect getCssContentSize() {
            return this.cssContentSize;
        }

        private static GetLayoutMetricsResponse fromJson(JsonInput input) {
            LayoutViewport layoutViewport = null;
            VisualViewport visualViewport = null;
            Rect contentSize = null;
            LayoutViewport cssLayoutViewport = null;
            VisualViewport cssVisualViewport = null;
            Rect cssContentSize = null;
            input.beginObject();
            block16: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "layoutViewport": {
                        layoutViewport = (LayoutViewport)input.read(LayoutViewport.class);
                        continue block16;
                    }
                    case "visualViewport": {
                        visualViewport = (VisualViewport)input.read(VisualViewport.class);
                        continue block16;
                    }
                    case "contentSize": {
                        contentSize = (Rect)input.read(Rect.class);
                        continue block16;
                    }
                    case "cssLayoutViewport": {
                        cssLayoutViewport = (LayoutViewport)input.read(LayoutViewport.class);
                        continue block16;
                    }
                    case "cssVisualViewport": {
                        cssVisualViewport = (VisualViewport)input.read(VisualViewport.class);
                        continue block16;
                    }
                    case "cssContentSize": {
                        cssContentSize = (Rect)input.read(Rect.class);
                        continue block16;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetLayoutMetricsResponse(layoutViewport, visualViewport, contentSize, cssLayoutViewport, cssVisualViewport, cssContentSize);
        }
    }

    public static class GetAppIdResponse {
        private final Optional<String> appId;
        private final Optional<String> recommendedId;

        public GetAppIdResponse(Optional<String> appId, Optional<String> recommendedId) {
            this.appId = appId;
            this.recommendedId = recommendedId;
        }

        public Optional<String> getAppId() {
            return this.appId;
        }

        public Optional<String> getRecommendedId() {
            return this.recommendedId;
        }

        private static GetAppIdResponse fromJson(JsonInput input) {
            Optional<String> appId = Optional.empty();
            Optional<String> recommendedId = Optional.empty();
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "appId": {
                        appId = Optional.ofNullable(input.nextString());
                        continue block8;
                    }
                    case "recommendedId": {
                        recommendedId = Optional.ofNullable(input.nextString());
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetAppIdResponse(appId, recommendedId);
        }
    }

    public static class GetAppManifestResponse {
        private final String url;
        private final List<AppManifestError> errors;
        private final Optional<String> data;
        private final Optional<AppManifestParsedProperties> parsed;

        public GetAppManifestResponse(String url, List<AppManifestError> errors, Optional<String> data, Optional<AppManifestParsedProperties> parsed) {
            this.url = Objects.requireNonNull(url, "url is required");
            this.errors = Objects.requireNonNull(errors, "errors is required");
            this.data = data;
            this.parsed = parsed;
        }

        public String getUrl() {
            return this.url;
        }

        public List<AppManifestError> getErrors() {
            return this.errors;
        }

        public Optional<String> getData() {
            return this.data;
        }

        public Optional<AppManifestParsedProperties> getParsed() {
            return this.parsed;
        }

        private static GetAppManifestResponse fromJson(JsonInput input) {
            String url = null;
            List errors = null;
            Optional<String> data = Optional.empty();
            Optional<AppManifestParsedProperties> parsed = Optional.empty();
            input.beginObject();
            block12: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "url": {
                        url = input.nextString();
                        continue block12;
                    }
                    case "errors": {
                        errors = (List)input.read(new TypeToken<List<AppManifestError>>(){}.getType());
                        continue block12;
                    }
                    case "data": {
                        data = Optional.ofNullable(input.nextString());
                        continue block12;
                    }
                    case "parsed": {
                        parsed = Optional.ofNullable((AppManifestParsedProperties)input.read(AppManifestParsedProperties.class));
                        continue block12;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetAppManifestResponse(url, errors, data, parsed);
        }
    }

    public static enum CaptureSnapshotFormat {
        MHTML("mhtml");

        private String value;

        private CaptureSnapshotFormat(String value) {
            this.value = value;
        }

        public static CaptureSnapshotFormat fromString(String s) {
            return Arrays.stream(CaptureSnapshotFormat.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within CaptureSnapshotFormat "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static CaptureSnapshotFormat fromJson(JsonInput input) {
            return CaptureSnapshotFormat.fromString(input.nextString());
        }
    }

    public static enum CaptureScreenshotFormat {
        JPEG("jpeg"),
        PNG("png"),
        WEBP("webp");

        private String value;

        private CaptureScreenshotFormat(String value) {
            this.value = value;
        }

        public static CaptureScreenshotFormat fromString(String s) {
            return Arrays.stream(CaptureScreenshotFormat.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within CaptureScreenshotFormat "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static CaptureScreenshotFormat fromJson(JsonInput input) {
            return CaptureScreenshotFormat.fromString(input.nextString());
        }
    }
}

