/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v110.tracing;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v110.tracing.model.BufferUsage;
import org.openqa.selenium.devtools.v110.tracing.model.MemoryDumpLevelOfDetail;
import org.openqa.selenium.devtools.v110.tracing.model.StreamCompression;
import org.openqa.selenium.devtools.v110.tracing.model.StreamFormat;
import org.openqa.selenium.devtools.v110.tracing.model.TraceConfig;
import org.openqa.selenium.devtools.v110.tracing.model.TracingBackend;
import org.openqa.selenium.devtools.v110.tracing.model.TracingComplete;
import org.openqa.selenium.json.JsonInput;

@Beta
public class Tracing {
    public static Command<Void> end() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Tracing.end", (Map)params.build());
    }

    public static Command<List<String>> getCategories() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Tracing.getCategories", (Map)params.build(), ConverterFunctions.map((String)"categories", (Type)new TypeToken<List<String>>(){}.getType()));
    }

    public static Command<Void> recordClockSyncMarker(String syncId) {
        Objects.requireNonNull(syncId, "syncId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"syncId", (Object)syncId);
        return new Command("Tracing.recordClockSyncMarker", (Map)params.build());
    }

    public static Command<RequestMemoryDumpResponse> requestMemoryDump(Optional<Boolean> deterministic, Optional<MemoryDumpLevelOfDetail> levelOfDetail) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        deterministic.ifPresent(p -> params.put((Object)"deterministic", p));
        levelOfDetail.ifPresent(p -> params.put((Object)"levelOfDetail", (Object)p));
        return new Command("Tracing.requestMemoryDump", (Map)params.build(), input -> (RequestMemoryDumpResponse)input.read(RequestMemoryDumpResponse.class));
    }

    public static Command<Void> start(Optional<String> categories, Optional<String> options, Optional<Number> bufferUsageReportingInterval, Optional<StartTransferMode> transferMode, Optional<StreamFormat> streamFormat, Optional<StreamCompression> streamCompression, Optional<TraceConfig> traceConfig, Optional<String> perfettoConfig, Optional<TracingBackend> tracingBackend) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        categories.ifPresent(p -> params.put((Object)"categories", p));
        options.ifPresent(p -> params.put((Object)"options", p));
        bufferUsageReportingInterval.ifPresent(p -> params.put((Object)"bufferUsageReportingInterval", p));
        transferMode.ifPresent(p -> params.put((Object)"transferMode", (Object)p));
        streamFormat.ifPresent(p -> params.put((Object)"streamFormat", (Object)p));
        streamCompression.ifPresent(p -> params.put((Object)"streamCompression", (Object)p));
        traceConfig.ifPresent(p -> params.put((Object)"traceConfig", p));
        perfettoConfig.ifPresent(p -> params.put((Object)"perfettoConfig", p));
        tracingBackend.ifPresent(p -> params.put((Object)"tracingBackend", (Object)p));
        return new Command("Tracing.start", (Map)params.build());
    }

    public static Event<BufferUsage> bufferUsage() {
        return new Event("Tracing.bufferUsage", input -> (BufferUsage)input.read(BufferUsage.class));
    }

    public static Event<List<Map<String, Object>>> dataCollected() {
        return new Event("Tracing.dataCollected", ConverterFunctions.map((String)"value", (Type)new TypeToken<List<Map<String, Object>>>(){}.getType()));
    }

    public static Event<TracingComplete> tracingComplete() {
        return new Event("Tracing.tracingComplete", input -> (TracingComplete)input.read(TracingComplete.class));
    }

    public static enum StartTransferMode {
        REPORTEVENTS("ReportEvents"),
        RETURNASSTREAM("ReturnAsStream");

        private String value;

        private StartTransferMode(String value) {
            this.value = value;
        }

        public static StartTransferMode fromString(String s) {
            return Arrays.stream(StartTransferMode.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within StartTransferMode "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static StartTransferMode fromJson(JsonInput input) {
            return StartTransferMode.fromString(input.nextString());
        }
    }

    public static class RequestMemoryDumpResponse {
        private final String dumpGuid;
        private final Boolean success;

        public RequestMemoryDumpResponse(String dumpGuid, Boolean success) {
            this.dumpGuid = Objects.requireNonNull(dumpGuid, "dumpGuid is required");
            this.success = Objects.requireNonNull(success, "success is required");
        }

        public String getDumpGuid() {
            return this.dumpGuid;
        }

        public Boolean getSuccess() {
            return this.success;
        }

        private static RequestMemoryDumpResponse fromJson(JsonInput input) {
            String dumpGuid = null;
            Boolean success = false;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "dumpGuid": {
                        dumpGuid = input.nextString();
                        continue block8;
                    }
                    case "success": {
                        success = input.nextBoolean();
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new RequestMemoryDumpResponse(dumpGuid, success);
        }
    }
}

