package org.openqa.selenium.devtools.v108.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public enum DeprecationIssueType {

    AUTHORIZATIONCOVEREDBYWILDCARD("AuthorizationCoveredByWildcard"),
    CANREQUESTURLHTTPCONTAININGNEWLINE("CanRequestURLHTTPContainingNewline"),
    CHROMELOADTIMESCONNECTIONINFO("ChromeLoadTimesConnectionInfo"),
    CHROMELOADTIMESFIRSTPAINTAFTERLOADTIME("ChromeLoadTimesFirstPaintAfterLoadTime"),
    CHROMELOADTIMESWASALTERNATEPROTOCOLAVAILABLE("ChromeLoadTimesWasAlternateProtocolAvailable"),
    COOKIEWITHTRUNCATINGCHAR("CookieWithTruncatingChar"),
    CROSSORIGINACCESSBASEDONDOCUMENTDOMAIN("CrossOriginAccessBasedOnDocumentDomain"),
    CROSSORIGINWINDOWALERT("CrossOriginWindowAlert"),
    CROSSORIGINWINDOWCONFIRM("CrossOriginWindowConfirm"),
    CSSSELECTORINTERNALMEDIACONTROLSOVERLAYCASTBUTTON("CSSSelectorInternalMediaControlsOverlayCastButton"),
    DEPRECATIONEXAMPLE("DeprecationExample"),
    DOCUMENTDOMAINSETTINGWITHOUTORIGINAGENTCLUSTERHEADER("DocumentDomainSettingWithoutOriginAgentClusterHeader"),
    EVENTPATH("EventPath"),
    EXPECTCTHEADER("ExpectCTHeader"),
    GEOLOCATIONINSECUREORIGIN("GeolocationInsecureOrigin"),
    GEOLOCATIONINSECUREORIGINDEPRECATEDNOTREMOVED("GeolocationInsecureOriginDeprecatedNotRemoved"),
    GETUSERMEDIAINSECUREORIGIN("GetUserMediaInsecureOrigin"),
    HOSTCANDIDATEATTRIBUTEGETTER("HostCandidateAttributeGetter"),
    IDENTITYINCANMAKEPAYMENTEVENT("IdentityInCanMakePaymentEvent"),
    INSECUREPRIVATENETWORKSUBRESOURCEREQUEST("InsecurePrivateNetworkSubresourceRequest"),
    LOCALCSSFILEEXTENSIONREJECTED("LocalCSSFileExtensionRejected"),
    MEDIASOURCEABORTREMOVE("MediaSourceAbortRemove"),
    MEDIASOURCEDURATIONTRUNCATINGBUFFERED("MediaSourceDurationTruncatingBuffered"),
    NOSYSEXWEBMIDIWITHOUTPERMISSION("NoSysexWebMIDIWithoutPermission"),
    NOTIFICATIONINSECUREORIGIN("NotificationInsecureOrigin"),
    NOTIFICATIONPERMISSIONREQUESTEDIFRAME("NotificationPermissionRequestedIframe"),
    OBSOLETEWEBRTCCIPHERSUITE("ObsoleteWebRtcCipherSuite"),
    OPENWEBDATABASEINSECURECONTEXT("OpenWebDatabaseInsecureContext"),
    OVERFLOWVISIBLEONREPLACEDELEMENT("OverflowVisibleOnReplacedElement"),
    PAYMENTINSTRUMENTS("PaymentInstruments"),
    PAYMENTREQUESTCSPVIOLATION("PaymentRequestCSPViolation"),
    PERSISTENTQUOTATYPE("PersistentQuotaType"),
    PICTURESOURCESRC("PictureSourceSrc"),
    PREFIXEDCANCELANIMATIONFRAME("PrefixedCancelAnimationFrame"),
    PREFIXEDREQUESTANIMATIONFRAME("PrefixedRequestAnimationFrame"),
    PREFIXEDSTORAGEINFO("PrefixedStorageInfo"),
    PREFIXEDVIDEODISPLAYINGFULLSCREEN("PrefixedVideoDisplayingFullscreen"),
    PREFIXEDVIDEOENTERFULLSCREEN("PrefixedVideoEnterFullscreen"),
    PREFIXEDVIDEOEXITFULLSCREEN("PrefixedVideoExitFullscreen"),
    PREFIXEDVIDEOSUPPORTSFULLSCREEN("PrefixedVideoSupportsFullscreen"),
    RANGEEXPAND("RangeExpand"),
    REQUESTEDSUBRESOURCEWITHEMBEDDEDCREDENTIALS("RequestedSubresourceWithEmbeddedCredentials"),
    RTCCONSTRAINTENABLEDTLSSRTPFALSE("RTCConstraintEnableDtlsSrtpFalse"),
    RTCCONSTRAINTENABLEDTLSSRTPTRUE("RTCConstraintEnableDtlsSrtpTrue"),
    RTCPEERCONNECTIONCOMPLEXPLANBSDPUSINGDEFAULTSDPSEMANTICS("RTCPeerConnectionComplexPlanBSdpUsingDefaultSdpSemantics"),
    RTCPEERCONNECTIONSDPSEMANTICSPLANB("RTCPeerConnectionSdpSemanticsPlanB"),
    RTCPMUXPOLICYNEGOTIATE("RtcpMuxPolicyNegotiate"),
    SHAREDARRAYBUFFERCONSTRUCTEDWITHOUTISOLATION("SharedArrayBufferConstructedWithoutIsolation"),
    TEXTTOSPEECH_DISALLOWEDBYAUTOPLAY("TextToSpeech_DisallowedByAutoplay"),
    V8SHAREDARRAYBUFFERCONSTRUCTEDINEXTENSIONWITHOUTISOLATION("V8SharedArrayBufferConstructedInExtensionWithoutIsolation"),
    XHRJSONENCODINGDETECTION("XHRJSONEncodingDetection"),
    XMLHTTPREQUESTSYNCHRONOUSINNONWORKEROUTSIDEBEFOREUNLOAD("XMLHttpRequestSynchronousInNonWorkerOutsideBeforeUnload"),
    XRSUPPORTSSESSION("XRSupportsSession");

    private String value;

    DeprecationIssueType(String value) {
        this.value = value;
    }

    public static DeprecationIssueType fromString(String s) {
        return java.util.Arrays.stream(DeprecationIssueType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within DeprecationIssueType "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static DeprecationIssueType fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
