package org.openqa.selenium.devtools.v106.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Indicates whether the frame is a secure context and why it is the case.
 */
@org.openqa.selenium.Beta()
public enum SecureContextType {

    SECURE("Secure"), SECURELOCALHOST("SecureLocalhost"), INSECURESCHEME("InsecureScheme"), INSECUREANCESTOR("InsecureAncestor");

    private String value;

    SecureContextType(String value) {
        this.value = value;
    }

    public static SecureContextType fromString(String s) {
        return java.util.Arrays.stream(SecureContextType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within SecureContextType "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static SecureContextType fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
