package org.openqa.selenium.devtools.v104.target.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public class TargetInfo {

    private final org.openqa.selenium.devtools.v104.target.model.TargetID targetId;

    private final java.lang.String type;

    private final java.lang.String title;

    private final java.lang.String url;

    private final java.lang.Boolean attached;

    private final java.util.Optional<org.openqa.selenium.devtools.v104.target.model.TargetID> openerId;

    private final java.lang.Boolean canAccessOpener;

    private final java.util.Optional<org.openqa.selenium.devtools.v104.page.model.FrameId> openerFrameId;

    private final java.util.Optional<org.openqa.selenium.devtools.v104.browser.model.BrowserContextID> browserContextId;

    public TargetInfo(org.openqa.selenium.devtools.v104.target.model.TargetID targetId, java.lang.String type, java.lang.String title, java.lang.String url, java.lang.Boolean attached, java.util.Optional<org.openqa.selenium.devtools.v104.target.model.TargetID> openerId, java.lang.Boolean canAccessOpener, java.util.Optional<org.openqa.selenium.devtools.v104.page.model.FrameId> openerFrameId, java.util.Optional<org.openqa.selenium.devtools.v104.browser.model.BrowserContextID> browserContextId) {
        this.targetId = java.util.Objects.requireNonNull(targetId, "targetId is required");
        this.type = java.util.Objects.requireNonNull(type, "type is required");
        this.title = java.util.Objects.requireNonNull(title, "title is required");
        this.url = java.util.Objects.requireNonNull(url, "url is required");
        this.attached = java.util.Objects.requireNonNull(attached, "attached is required");
        this.openerId = openerId;
        this.canAccessOpener = java.util.Objects.requireNonNull(canAccessOpener, "canAccessOpener is required");
        this.openerFrameId = openerFrameId;
        this.browserContextId = browserContextId;
    }

    public org.openqa.selenium.devtools.v104.target.model.TargetID getTargetId() {
        return targetId;
    }

    public java.lang.String getType() {
        return type;
    }

    public java.lang.String getTitle() {
        return title;
    }

    public java.lang.String getUrl() {
        return url;
    }

    /**
     * Whether the target has an attached client.
     */
    public java.lang.Boolean getAttached() {
        return attached;
    }

    /**
     * Opener target Id
     */
    public java.util.Optional<org.openqa.selenium.devtools.v104.target.model.TargetID> getOpenerId() {
        return openerId;
    }

    /**
     * Whether the target has access to the originating window.
     */
    @Beta()
    public java.lang.Boolean getCanAccessOpener() {
        return canAccessOpener;
    }

    /**
     * Frame id of originating window (is only set if target has an opener).
     */
    @Beta()
    public java.util.Optional<org.openqa.selenium.devtools.v104.page.model.FrameId> getOpenerFrameId() {
        return openerFrameId;
    }

    @Beta()
    public java.util.Optional<org.openqa.selenium.devtools.v104.browser.model.BrowserContextID> getBrowserContextId() {
        return browserContextId;
    }

    private static TargetInfo fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v104.target.model.TargetID targetId = null;
        java.lang.String type = null;
        java.lang.String title = null;
        java.lang.String url = null;
        java.lang.Boolean attached = false;
        java.util.Optional<org.openqa.selenium.devtools.v104.target.model.TargetID> openerId = java.util.Optional.empty();
        java.lang.Boolean canAccessOpener = false;
        java.util.Optional<org.openqa.selenium.devtools.v104.page.model.FrameId> openerFrameId = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v104.browser.model.BrowserContextID> browserContextId = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "targetId":
                    targetId = input.read(org.openqa.selenium.devtools.v104.target.model.TargetID.class);
                    break;
                case "type":
                    type = input.nextString();
                    break;
                case "title":
                    title = input.nextString();
                    break;
                case "url":
                    url = input.nextString();
                    break;
                case "attached":
                    attached = input.nextBoolean();
                    break;
                case "openerId":
                    openerId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v104.target.model.TargetID.class));
                    break;
                case "canAccessOpener":
                    canAccessOpener = input.nextBoolean();
                    break;
                case "openerFrameId":
                    openerFrameId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v104.page.model.FrameId.class));
                    break;
                case "browserContextId":
                    browserContextId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v104.browser.model.BrowserContextID.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new TargetInfo(targetId, type, title, url, attached, openerId, canAccessOpener, openerFrameId, browserContextId);
    }
}
