package org.openqa.selenium.devtools.v104.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * The reason why request was blocked.
 */
public enum BlockedReason {

    OTHER("other"),
    CSP("csp"),
    MIXED_CONTENT("mixed-content"),
    ORIGIN("origin"),
    INSPECTOR("inspector"),
    SUBRESOURCE_FILTER("subresource-filter"),
    CONTENT_TYPE("content-type"),
    COEP_FRAME_RESOURCE_NEEDS_COEP_HEADER("coep-frame-resource-needs-coep-header"),
    COOP_SANDBOXED_IFRAME_CANNOT_NAVIGATE_TO_COOP_PAGE("coop-sandboxed-iframe-cannot-navigate-to-coop-page"),
    CORP_NOT_SAME_ORIGIN("corp-not-same-origin"),
    CORP_NOT_SAME_ORIGIN_AFTER_DEFAULTED_TO_SAME_ORIGIN_BY_COEP("corp-not-same-origin-after-defaulted-to-same-origin-by-coep"),
    CORP_NOT_SAME_SITE("corp-not-same-site");

    private String value;

    BlockedReason(String value) {
        this.value = value;
    }

    public static BlockedReason fromString(String s) {
        return java.util.Arrays.stream(BlockedReason.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within BlockedReason "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static BlockedReason fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
