package org.openqa.selenium.devtools.v104.accessibility;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import com.google.common.collect.ImmutableMap;
import org.openqa.selenium.json.JsonInput;

@Beta()
public class Accessibility {

    /**
     * Disables the accessibility domain.
     */
    public static Command<Void> disable() {
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        return new Command<>("Accessibility.disable", params.build());
    }

    /**
     * Enables the accessibility domain which causes `AXNodeId`s to remain consistent between method calls.
     * This turns on accessibility for the page, which can impact performance until accessibility is disabled.
     */
    public static Command<Void> enable() {
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        return new Command<>("Accessibility.enable", params.build());
    }

    /**
     * Fetches the accessibility node and partial accessibility tree for this DOM node, if it exists.
     */
    @Beta()
    public static Command<java.util.List<org.openqa.selenium.devtools.v104.accessibility.model.AXNode>> getPartialAXTree(java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.NodeId> nodeId, java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.BackendNodeId> backendNodeId, java.util.Optional<org.openqa.selenium.devtools.v104.runtime.model.RemoteObjectId> objectId, java.util.Optional<java.lang.Boolean> fetchRelatives) {
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        nodeId.ifPresent(p -> params.put("nodeId", p));
        backendNodeId.ifPresent(p -> params.put("backendNodeId", p));
        objectId.ifPresent(p -> params.put("objectId", p));
        fetchRelatives.ifPresent(p -> params.put("fetchRelatives", p));
        return new Command<>("Accessibility.getPartialAXTree", params.build(), ConverterFunctions.map("nodes", new com.google.common.reflect.TypeToken<java.util.List<org.openqa.selenium.devtools.v104.accessibility.model.AXNode>>() {
        }.getType()));
    }

    /**
     * Fetches the entire accessibility tree for the root Document
     */
    @Beta()
    public static Command<java.util.List<org.openqa.selenium.devtools.v104.accessibility.model.AXNode>> getFullAXTree(java.util.Optional<java.lang.Integer> depth, java.util.Optional<org.openqa.selenium.devtools.v104.page.model.FrameId> frameId) {
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        depth.ifPresent(p -> params.put("depth", p));
        frameId.ifPresent(p -> params.put("frameId", p));
        return new Command<>("Accessibility.getFullAXTree", params.build(), ConverterFunctions.map("nodes", new com.google.common.reflect.TypeToken<java.util.List<org.openqa.selenium.devtools.v104.accessibility.model.AXNode>>() {
        }.getType()));
    }

    /**
     * Fetches the root node.
     * Requires `enable()` to have been called previously.
     */
    @Beta()
    public static Command<org.openqa.selenium.devtools.v104.accessibility.model.AXNode> getRootAXNode(java.util.Optional<org.openqa.selenium.devtools.v104.page.model.FrameId> frameId) {
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        frameId.ifPresent(p -> params.put("frameId", p));
        return new Command<>("Accessibility.getRootAXNode", params.build(), ConverterFunctions.map("node", org.openqa.selenium.devtools.v104.accessibility.model.AXNode.class));
    }

    /**
     * Fetches a node and all ancestors up to and including the root.
     * Requires `enable()` to have been called previously.
     */
    @Beta()
    public static Command<java.util.List<org.openqa.selenium.devtools.v104.accessibility.model.AXNode>> getAXNodeAndAncestors(java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.NodeId> nodeId, java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.BackendNodeId> backendNodeId, java.util.Optional<org.openqa.selenium.devtools.v104.runtime.model.RemoteObjectId> objectId) {
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        nodeId.ifPresent(p -> params.put("nodeId", p));
        backendNodeId.ifPresent(p -> params.put("backendNodeId", p));
        objectId.ifPresent(p -> params.put("objectId", p));
        return new Command<>("Accessibility.getAXNodeAndAncestors", params.build(), ConverterFunctions.map("nodes", new com.google.common.reflect.TypeToken<java.util.List<org.openqa.selenium.devtools.v104.accessibility.model.AXNode>>() {
        }.getType()));
    }

    /**
     * Fetches a particular accessibility node by AXNodeId.
     * Requires `enable()` to have been called previously.
     */
    @Beta()
    public static Command<java.util.List<org.openqa.selenium.devtools.v104.accessibility.model.AXNode>> getChildAXNodes(org.openqa.selenium.devtools.v104.accessibility.model.AXNodeId id, java.util.Optional<org.openqa.selenium.devtools.v104.page.model.FrameId> frameId) {
        java.util.Objects.requireNonNull(id, "id is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("id", id);
        frameId.ifPresent(p -> params.put("frameId", p));
        return new Command<>("Accessibility.getChildAXNodes", params.build(), ConverterFunctions.map("nodes", new com.google.common.reflect.TypeToken<java.util.List<org.openqa.selenium.devtools.v104.accessibility.model.AXNode>>() {
        }.getType()));
    }

    /**
     * Query a DOM node's accessibility subtree for accessible name and role.
     * This command computes the name and role for all nodes in the subtree, including those that are
     * ignored for accessibility, and returns those that mactch the specified name and role. If no DOM
     * node is specified, or the DOM node does not exist, the command returns an error. If neither
     * `accessibleName` or `role` is specified, it returns all the accessibility nodes in the subtree.
     */
    @Beta()
    public static Command<java.util.List<org.openqa.selenium.devtools.v104.accessibility.model.AXNode>> queryAXTree(java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.NodeId> nodeId, java.util.Optional<org.openqa.selenium.devtools.v104.dom.model.BackendNodeId> backendNodeId, java.util.Optional<org.openqa.selenium.devtools.v104.runtime.model.RemoteObjectId> objectId, java.util.Optional<java.lang.String> accessibleName, java.util.Optional<java.lang.String> role) {
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        nodeId.ifPresent(p -> params.put("nodeId", p));
        backendNodeId.ifPresent(p -> params.put("backendNodeId", p));
        objectId.ifPresent(p -> params.put("objectId", p));
        accessibleName.ifPresent(p -> params.put("accessibleName", p));
        role.ifPresent(p -> params.put("role", p));
        return new Command<>("Accessibility.queryAXTree", params.build(), ConverterFunctions.map("nodes", new com.google.common.reflect.TypeToken<java.util.List<org.openqa.selenium.devtools.v104.accessibility.model.AXNode>>() {
        }.getType()));
    }

    public static Event<org.openqa.selenium.devtools.v104.accessibility.model.AXNode> loadComplete() {
        return new Event<>("Accessibility.loadComplete", ConverterFunctions.map("root", org.openqa.selenium.devtools.v104.accessibility.model.AXNode.class));
    }

    public static Event<java.util.List<org.openqa.selenium.devtools.v104.accessibility.model.AXNode>> nodesUpdated() {
        return new Event<>("Accessibility.nodesUpdated", ConverterFunctions.map("nodes", new com.google.common.reflect.TypeToken<java.util.List<org.openqa.selenium.devtools.v104.accessibility.model.AXNode>>() {
        }.getType()));
    }
}
