package org.openqa.selenium.devtools.v103.overlay.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public class ScrollSnapContainerHighlightConfig {

    private final java.util.Optional<org.openqa.selenium.devtools.v103.overlay.model.LineStyle> snapportBorder;

    private final java.util.Optional<org.openqa.selenium.devtools.v103.overlay.model.LineStyle> snapAreaBorder;

    private final java.util.Optional<org.openqa.selenium.devtools.v103.dom.model.RGBA> scrollMarginColor;

    private final java.util.Optional<org.openqa.selenium.devtools.v103.dom.model.RGBA> scrollPaddingColor;

    public ScrollSnapContainerHighlightConfig(java.util.Optional<org.openqa.selenium.devtools.v103.overlay.model.LineStyle> snapportBorder, java.util.Optional<org.openqa.selenium.devtools.v103.overlay.model.LineStyle> snapAreaBorder, java.util.Optional<org.openqa.selenium.devtools.v103.dom.model.RGBA> scrollMarginColor, java.util.Optional<org.openqa.selenium.devtools.v103.dom.model.RGBA> scrollPaddingColor) {
        this.snapportBorder = snapportBorder;
        this.snapAreaBorder = snapAreaBorder;
        this.scrollMarginColor = scrollMarginColor;
        this.scrollPaddingColor = scrollPaddingColor;
    }

    /**
     * The style of the snapport border (default: transparent)
     */
    public java.util.Optional<org.openqa.selenium.devtools.v103.overlay.model.LineStyle> getSnapportBorder() {
        return snapportBorder;
    }

    /**
     * The style of the snap area border (default: transparent)
     */
    public java.util.Optional<org.openqa.selenium.devtools.v103.overlay.model.LineStyle> getSnapAreaBorder() {
        return snapAreaBorder;
    }

    /**
     * The margin highlight fill color (default: transparent).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v103.dom.model.RGBA> getScrollMarginColor() {
        return scrollMarginColor;
    }

    /**
     * The padding highlight fill color (default: transparent).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v103.dom.model.RGBA> getScrollPaddingColor() {
        return scrollPaddingColor;
    }

    private static ScrollSnapContainerHighlightConfig fromJson(JsonInput input) {
        java.util.Optional<org.openqa.selenium.devtools.v103.overlay.model.LineStyle> snapportBorder = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v103.overlay.model.LineStyle> snapAreaBorder = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v103.dom.model.RGBA> scrollMarginColor = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v103.dom.model.RGBA> scrollPaddingColor = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "snapportBorder":
                    snapportBorder = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v103.overlay.model.LineStyle.class));
                    break;
                case "snapAreaBorder":
                    snapAreaBorder = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v103.overlay.model.LineStyle.class));
                    break;
                case "scrollMarginColor":
                    scrollMarginColor = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v103.dom.model.RGBA.class));
                    break;
                case "scrollPaddingColor":
                    scrollPaddingColor = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v103.dom.model.RGBA.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new ScrollSnapContainerHighlightConfig(snapportBorder, snapAreaBorder, scrollMarginColor, scrollPaddingColor);
    }
}
