package org.openqa.selenium.devtools.v103.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public class ReportingApiEndpoint {

    private final java.lang.String url;

    private final java.lang.String groupName;

    public ReportingApiEndpoint(java.lang.String url, java.lang.String groupName) {
        this.url = java.util.Objects.requireNonNull(url, "url is required");
        this.groupName = java.util.Objects.requireNonNull(groupName, "groupName is required");
    }

    /**
     * The URL of the endpoint to which reports may be delivered.
     */
    public java.lang.String getUrl() {
        return url;
    }

    /**
     * Name of the endpoint group.
     */
    public java.lang.String getGroupName() {
        return groupName;
    }

    private static ReportingApiEndpoint fromJson(JsonInput input) {
        java.lang.String url = null;
        java.lang.String groupName = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "url":
                    url = input.nextString();
                    break;
                case "groupName":
                    groupName = input.nextString();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new ReportingApiEndpoint(url, groupName);
    }
}
