/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v102.webauthn.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.json.JsonInput;

public class Credential {
    private final String credentialId;
    private final Boolean isResidentCredential;
    private final Optional<String> rpId;
    private final String privateKey;
    private final Optional<String> userHandle;
    private final Integer signCount;
    private final Optional<String> largeBlob;

    public Credential(String credentialId, Boolean isResidentCredential, Optional<String> rpId, String privateKey, Optional<String> userHandle, Integer signCount, Optional<String> largeBlob) {
        this.credentialId = Objects.requireNonNull(credentialId, "credentialId is required");
        this.isResidentCredential = Objects.requireNonNull(isResidentCredential, "isResidentCredential is required");
        this.rpId = rpId;
        this.privateKey = Objects.requireNonNull(privateKey, "privateKey is required");
        this.userHandle = userHandle;
        this.signCount = Objects.requireNonNull(signCount, "signCount is required");
        this.largeBlob = largeBlob;
    }

    public String getCredentialId() {
        return this.credentialId;
    }

    public Boolean getIsResidentCredential() {
        return this.isResidentCredential;
    }

    public Optional<String> getRpId() {
        return this.rpId;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public Optional<String> getUserHandle() {
        return this.userHandle;
    }

    public Integer getSignCount() {
        return this.signCount;
    }

    public Optional<String> getLargeBlob() {
        return this.largeBlob;
    }

    private static Credential fromJson(JsonInput input) {
        String credentialId = null;
        Boolean isResidentCredential = false;
        Optional<String> rpId = Optional.empty();
        String privateKey = null;
        Optional<String> userHandle = Optional.empty();
        Integer signCount = 0;
        Optional<String> largeBlob = Optional.empty();
        input.beginObject();
        block18: while (input.hasNext()) {
            switch (input.nextName()) {
                case "credentialId": {
                    credentialId = input.nextString();
                    continue block18;
                }
                case "isResidentCredential": {
                    isResidentCredential = input.nextBoolean();
                    continue block18;
                }
                case "rpId": {
                    rpId = Optional.ofNullable(input.nextString());
                    continue block18;
                }
                case "privateKey": {
                    privateKey = input.nextString();
                    continue block18;
                }
                case "userHandle": {
                    userHandle = Optional.ofNullable(input.nextString());
                    continue block18;
                }
                case "signCount": {
                    signCount = input.nextNumber().intValue();
                    continue block18;
                }
                case "largeBlob": {
                    largeBlob = Optional.ofNullable(input.nextString());
                    continue block18;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Credential(credentialId, isResidentCredential, rpId, privateKey, userHandle, signCount, largeBlob);
    }
}

