package org.openqa.selenium.devtools.v102.overlay;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import com.google.common.collect.ImmutableMap;
import org.openqa.selenium.json.JsonInput;

/**
 * This domain provides various functionality related to drawing atop the inspected page.
 */
@Beta()
public class Overlay {

    /**
     * Disables domain notifications.
     */
    public static Command<Void> disable() {
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        return new Command<>("Overlay.disable", params.build());
    }

    /**
     * Enables domain notifications.
     */
    public static Command<Void> enable() {
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        return new Command<>("Overlay.enable", params.build());
    }

    /**
     * For testing.
     */
    public static Command<java.util.Map<String, Object>> getHighlightObjectForTest(org.openqa.selenium.devtools.v102.dom.model.NodeId nodeId, java.util.Optional<java.lang.Boolean> includeDistance, java.util.Optional<java.lang.Boolean> includeStyle, java.util.Optional<org.openqa.selenium.devtools.v102.overlay.model.ColorFormat> colorFormat, java.util.Optional<java.lang.Boolean> showAccessibilityInfo) {
        java.util.Objects.requireNonNull(nodeId, "nodeId is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("nodeId", nodeId);
        includeDistance.ifPresent(p -> params.put("includeDistance", p));
        includeStyle.ifPresent(p -> params.put("includeStyle", p));
        colorFormat.ifPresent(p -> params.put("colorFormat", p));
        showAccessibilityInfo.ifPresent(p -> params.put("showAccessibilityInfo", p));
        return new Command<>("Overlay.getHighlightObjectForTest", params.build(), ConverterFunctions.map("highlight", new com.google.common.reflect.TypeToken<java.util.Map<String, Object>>() {
        }.getType()));
    }

    /**
     * For Persistent Grid testing.
     */
    public static Command<java.util.Map<String, Object>> getGridHighlightObjectsForTest(java.util.List<org.openqa.selenium.devtools.v102.dom.model.NodeId> nodeIds) {
        java.util.Objects.requireNonNull(nodeIds, "nodeIds is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("nodeIds", nodeIds);
        return new Command<>("Overlay.getGridHighlightObjectsForTest", params.build(), ConverterFunctions.map("highlights", new com.google.common.reflect.TypeToken<java.util.Map<String, Object>>() {
        }.getType()));
    }

    /**
     * For Source Order Viewer testing.
     */
    public static Command<java.util.Map<String, Object>> getSourceOrderHighlightObjectForTest(org.openqa.selenium.devtools.v102.dom.model.NodeId nodeId) {
        java.util.Objects.requireNonNull(nodeId, "nodeId is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("nodeId", nodeId);
        return new Command<>("Overlay.getSourceOrderHighlightObjectForTest", params.build(), ConverterFunctions.map("highlight", new com.google.common.reflect.TypeToken<java.util.Map<String, Object>>() {
        }.getType()));
    }

    /**
     * Hides any highlight.
     */
    public static Command<Void> hideHighlight() {
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        return new Command<>("Overlay.hideHighlight", params.build());
    }

    /**
     * Highlights owner element of the frame with given id.
     * Deprecated: Doesn't work reliablity and cannot be fixed due to process
     * separatation (the owner node might be in a different process). Determine
     * the owner node in the client and use highlightNode.
     */
    @Deprecated()
    public static Command<Void> highlightFrame(org.openqa.selenium.devtools.v102.page.model.FrameId frameId, java.util.Optional<org.openqa.selenium.devtools.v102.dom.model.RGBA> contentColor, java.util.Optional<org.openqa.selenium.devtools.v102.dom.model.RGBA> contentOutlineColor) {
        java.util.Objects.requireNonNull(frameId, "frameId is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("frameId", frameId);
        contentColor.ifPresent(p -> params.put("contentColor", p));
        contentOutlineColor.ifPresent(p -> params.put("contentOutlineColor", p));
        return new Command<>("Overlay.highlightFrame", params.build());
    }

    /**
     * Highlights DOM node with given id or with the given JavaScript object wrapper. Either nodeId or
     * objectId must be specified.
     */
    public static Command<Void> highlightNode(org.openqa.selenium.devtools.v102.overlay.model.HighlightConfig highlightConfig, java.util.Optional<org.openqa.selenium.devtools.v102.dom.model.NodeId> nodeId, java.util.Optional<org.openqa.selenium.devtools.v102.dom.model.BackendNodeId> backendNodeId, java.util.Optional<org.openqa.selenium.devtools.v102.runtime.model.RemoteObjectId> objectId, java.util.Optional<java.lang.String> selector) {
        java.util.Objects.requireNonNull(highlightConfig, "highlightConfig is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("highlightConfig", highlightConfig);
        nodeId.ifPresent(p -> params.put("nodeId", p));
        backendNodeId.ifPresent(p -> params.put("backendNodeId", p));
        objectId.ifPresent(p -> params.put("objectId", p));
        selector.ifPresent(p -> params.put("selector", p));
        return new Command<>("Overlay.highlightNode", params.build());
    }

    /**
     * Highlights given quad. Coordinates are absolute with respect to the main frame viewport.
     */
    public static Command<Void> highlightQuad(org.openqa.selenium.devtools.v102.dom.model.Quad quad, java.util.Optional<org.openqa.selenium.devtools.v102.dom.model.RGBA> color, java.util.Optional<org.openqa.selenium.devtools.v102.dom.model.RGBA> outlineColor) {
        java.util.Objects.requireNonNull(quad, "quad is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("quad", quad);
        color.ifPresent(p -> params.put("color", p));
        outlineColor.ifPresent(p -> params.put("outlineColor", p));
        return new Command<>("Overlay.highlightQuad", params.build());
    }

    /**
     * Highlights given rectangle. Coordinates are absolute with respect to the main frame viewport.
     */
    public static Command<Void> highlightRect(java.lang.Integer x, java.lang.Integer y, java.lang.Integer width, java.lang.Integer height, java.util.Optional<org.openqa.selenium.devtools.v102.dom.model.RGBA> color, java.util.Optional<org.openqa.selenium.devtools.v102.dom.model.RGBA> outlineColor) {
        java.util.Objects.requireNonNull(x, "x is required");
        java.util.Objects.requireNonNull(y, "y is required");
        java.util.Objects.requireNonNull(width, "width is required");
        java.util.Objects.requireNonNull(height, "height is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("x", x);
        params.put("y", y);
        params.put("width", width);
        params.put("height", height);
        color.ifPresent(p -> params.put("color", p));
        outlineColor.ifPresent(p -> params.put("outlineColor", p));
        return new Command<>("Overlay.highlightRect", params.build());
    }

    /**
     * Highlights the source order of the children of the DOM node with given id or with the given
     * JavaScript object wrapper. Either nodeId or objectId must be specified.
     */
    public static Command<Void> highlightSourceOrder(org.openqa.selenium.devtools.v102.overlay.model.SourceOrderConfig sourceOrderConfig, java.util.Optional<org.openqa.selenium.devtools.v102.dom.model.NodeId> nodeId, java.util.Optional<org.openqa.selenium.devtools.v102.dom.model.BackendNodeId> backendNodeId, java.util.Optional<org.openqa.selenium.devtools.v102.runtime.model.RemoteObjectId> objectId) {
        java.util.Objects.requireNonNull(sourceOrderConfig, "sourceOrderConfig is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("sourceOrderConfig", sourceOrderConfig);
        nodeId.ifPresent(p -> params.put("nodeId", p));
        backendNodeId.ifPresent(p -> params.put("backendNodeId", p));
        objectId.ifPresent(p -> params.put("objectId", p));
        return new Command<>("Overlay.highlightSourceOrder", params.build());
    }

    /**
     * Enters the 'inspect' mode. In this mode, elements that user is hovering over are highlighted.
     * Backend then generates 'inspectNodeRequested' event upon element selection.
     */
    public static Command<Void> setInspectMode(org.openqa.selenium.devtools.v102.overlay.model.InspectMode mode, java.util.Optional<org.openqa.selenium.devtools.v102.overlay.model.HighlightConfig> highlightConfig) {
        java.util.Objects.requireNonNull(mode, "mode is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("mode", mode);
        highlightConfig.ifPresent(p -> params.put("highlightConfig", p));
        return new Command<>("Overlay.setInspectMode", params.build());
    }

    /**
     * Highlights owner element of all frames detected to be ads.
     */
    public static Command<Void> setShowAdHighlights(java.lang.Boolean show) {
        java.util.Objects.requireNonNull(show, "show is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("show", show);
        return new Command<>("Overlay.setShowAdHighlights", params.build());
    }

    public static Command<Void> setPausedInDebuggerMessage(java.util.Optional<java.lang.String> message) {
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        message.ifPresent(p -> params.put("message", p));
        return new Command<>("Overlay.setPausedInDebuggerMessage", params.build());
    }

    /**
     * Requests that backend shows debug borders on layers
     */
    public static Command<Void> setShowDebugBorders(java.lang.Boolean show) {
        java.util.Objects.requireNonNull(show, "show is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("show", show);
        return new Command<>("Overlay.setShowDebugBorders", params.build());
    }

    /**
     * Requests that backend shows the FPS counter
     */
    public static Command<Void> setShowFPSCounter(java.lang.Boolean show) {
        java.util.Objects.requireNonNull(show, "show is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("show", show);
        return new Command<>("Overlay.setShowFPSCounter", params.build());
    }

    /**
     * Highlight multiple elements with the CSS Grid overlay.
     */
    public static Command<Void> setShowGridOverlays(java.util.List<org.openqa.selenium.devtools.v102.overlay.model.GridNodeHighlightConfig> gridNodeHighlightConfigs) {
        java.util.Objects.requireNonNull(gridNodeHighlightConfigs, "gridNodeHighlightConfigs is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("gridNodeHighlightConfigs", gridNodeHighlightConfigs);
        return new Command<>("Overlay.setShowGridOverlays", params.build());
    }

    public static Command<Void> setShowFlexOverlays(java.util.List<org.openqa.selenium.devtools.v102.overlay.model.FlexNodeHighlightConfig> flexNodeHighlightConfigs) {
        java.util.Objects.requireNonNull(flexNodeHighlightConfigs, "flexNodeHighlightConfigs is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("flexNodeHighlightConfigs", flexNodeHighlightConfigs);
        return new Command<>("Overlay.setShowFlexOverlays", params.build());
    }

    public static Command<Void> setShowScrollSnapOverlays(java.util.List<org.openqa.selenium.devtools.v102.overlay.model.ScrollSnapHighlightConfig> scrollSnapHighlightConfigs) {
        java.util.Objects.requireNonNull(scrollSnapHighlightConfigs, "scrollSnapHighlightConfigs is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("scrollSnapHighlightConfigs", scrollSnapHighlightConfigs);
        return new Command<>("Overlay.setShowScrollSnapOverlays", params.build());
    }

    public static Command<Void> setShowContainerQueryOverlays(java.util.List<org.openqa.selenium.devtools.v102.overlay.model.ContainerQueryHighlightConfig> containerQueryHighlightConfigs) {
        java.util.Objects.requireNonNull(containerQueryHighlightConfigs, "containerQueryHighlightConfigs is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("containerQueryHighlightConfigs", containerQueryHighlightConfigs);
        return new Command<>("Overlay.setShowContainerQueryOverlays", params.build());
    }

    /**
     * Requests that backend shows paint rectangles
     */
    public static Command<Void> setShowPaintRects(java.lang.Boolean result) {
        java.util.Objects.requireNonNull(result, "result is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("result", result);
        return new Command<>("Overlay.setShowPaintRects", params.build());
    }

    /**
     * Requests that backend shows layout shift regions
     */
    public static Command<Void> setShowLayoutShiftRegions(java.lang.Boolean result) {
        java.util.Objects.requireNonNull(result, "result is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("result", result);
        return new Command<>("Overlay.setShowLayoutShiftRegions", params.build());
    }

    /**
     * Requests that backend shows scroll bottleneck rects
     */
    public static Command<Void> setShowScrollBottleneckRects(java.lang.Boolean show) {
        java.util.Objects.requireNonNull(show, "show is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("show", show);
        return new Command<>("Overlay.setShowScrollBottleneckRects", params.build());
    }

    /**
     * Deprecated, no longer has any effect.
     */
    @Deprecated()
    public static Command<Void> setShowHitTestBorders(java.lang.Boolean show) {
        java.util.Objects.requireNonNull(show, "show is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("show", show);
        return new Command<>("Overlay.setShowHitTestBorders", params.build());
    }

    /**
     * Request that backend shows an overlay with web vital metrics.
     */
    public static Command<Void> setShowWebVitals(java.lang.Boolean show) {
        java.util.Objects.requireNonNull(show, "show is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("show", show);
        return new Command<>("Overlay.setShowWebVitals", params.build());
    }

    /**
     * Paints viewport size upon main frame resize.
     */
    public static Command<Void> setShowViewportSizeOnResize(java.lang.Boolean show) {
        java.util.Objects.requireNonNull(show, "show is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("show", show);
        return new Command<>("Overlay.setShowViewportSizeOnResize", params.build());
    }

    /**
     * Add a dual screen device hinge
     */
    public static Command<Void> setShowHinge(java.util.Optional<org.openqa.selenium.devtools.v102.overlay.model.HingeConfig> hingeConfig) {
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        hingeConfig.ifPresent(p -> params.put("hingeConfig", p));
        return new Command<>("Overlay.setShowHinge", params.build());
    }

    /**
     * Show elements in isolation mode with overlays.
     */
    public static Command<Void> setShowIsolatedElements(java.util.List<org.openqa.selenium.devtools.v102.overlay.model.IsolatedElementHighlightConfig> isolatedElementHighlightConfigs) {
        java.util.Objects.requireNonNull(isolatedElementHighlightConfigs, "isolatedElementHighlightConfigs is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("isolatedElementHighlightConfigs", isolatedElementHighlightConfigs);
        return new Command<>("Overlay.setShowIsolatedElements", params.build());
    }

    public static Event<org.openqa.selenium.devtools.v102.dom.model.BackendNodeId> inspectNodeRequested() {
        return new Event<>("Overlay.inspectNodeRequested", ConverterFunctions.map("backendNodeId", org.openqa.selenium.devtools.v102.dom.model.BackendNodeId.class));
    }

    public static Event<org.openqa.selenium.devtools.v102.dom.model.NodeId> nodeHighlightRequested() {
        return new Event<>("Overlay.nodeHighlightRequested", ConverterFunctions.map("nodeId", org.openqa.selenium.devtools.v102.dom.model.NodeId.class));
    }

    public static Event<org.openqa.selenium.devtools.v102.page.model.Viewport> screenshotRequested() {
        return new Event<>("Overlay.screenshotRequested", ConverterFunctions.map("viewport", org.openqa.selenium.devtools.v102.page.model.Viewport.class));
    }

    public static Event<Void> inspectModeCanceled() {
        return new Event<>("Overlay.inspectModeCanceled", input -> null);
    }
}
