package org.openqa.selenium.devtools.v101.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * An options object that may be extended later to better support CORS,
 * CORB and streaming.
 */
@org.openqa.selenium.Beta()
public class LoadNetworkResourceOptions {

    private final java.lang.Boolean disableCache;

    private final java.lang.Boolean includeCredentials;

    public LoadNetworkResourceOptions(java.lang.Boolean disableCache, java.lang.Boolean includeCredentials) {
        this.disableCache = java.util.Objects.requireNonNull(disableCache, "disableCache is required");
        this.includeCredentials = java.util.Objects.requireNonNull(includeCredentials, "includeCredentials is required");
    }

    public java.lang.Boolean getDisableCache() {
        return disableCache;
    }

    public java.lang.Boolean getIncludeCredentials() {
        return includeCredentials;
    }

    private static LoadNetworkResourceOptions fromJson(JsonInput input) {
        java.lang.Boolean disableCache = false;
        java.lang.Boolean includeCredentials = false;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "disableCache":
                    disableCache = input.nextBoolean();
                    break;
                case "includeCredentials":
                    includeCredentials = input.nextBoolean();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new LoadNetworkResourceOptions(disableCache, includeCredentials);
    }
}
