package org.openqa.selenium.devtools.v100.eventbreakpoints;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import com.google.common.collect.ImmutableMap;
import org.openqa.selenium.json.JsonInput;

/**
 * EventBreakpoints permits setting breakpoints on particular operations and
 * events in targets that run JavaScript but do not have a DOM.
 * JavaScript execution will stop on these operations as if there was a regular
 * breakpoint set.
 */
@Beta()
public class EventBreakpoints {

    /**
     * Sets breakpoint on particular native event.
     */
    public static Command<Void> setInstrumentationBreakpoint(java.lang.String eventName) {
        java.util.Objects.requireNonNull(eventName, "eventName is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("eventName", eventName);
        return new Command<>("EventBreakpoints.setInstrumentationBreakpoint", params.build());
    }

    /**
     * Removes breakpoint on particular native event.
     */
    public static Command<Void> removeInstrumentationBreakpoint(java.lang.String eventName) {
        java.util.Objects.requireNonNull(eventName, "eventName is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("eventName", eventName);
        return new Command<>("EventBreakpoints.removeInstrumentationBreakpoint", params.build());
    }
}
