/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chrome;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.openqa.selenium.Beta;
import org.openqa.selenium.remote.service.DriverService;

public class ChromeDriverService
extends DriverService {
    public static final String CHROME_DRIVER_EXE_PROPERTY = "webdriver.chrome.driver";

    private ChromeDriverService(File executable, int port, ImmutableMap<String, String> environment, File logFile) throws IOException {
        super(executable, port, environment, logFile);
    }

    public static ChromeDriverService createDefaultService() {
        File exe = ChromeDriverService.findExecutable((String)"chromedriver", (String)CHROME_DRIVER_EXE_PROPERTY, (String)"http://code.google.com/p/selenium/wiki/ChromeDriver", (String)"http://code.google.com/p/chromedriver/downloads/list");
        return new Builder().usingDriverExecutable(exe).usingAnyFreePort().build();
    }

    public static class Builder
    extends DriverService.Builder {
        public Builder usingChromeDriverExecutable(File file) {
            return this.usingDriverExecutable(file);
        }

        public Builder usingDriverExecutable(File file) {
            super.usingDriverExecutable(file);
            return this;
        }

        public Builder usingPort(int port) {
            super.usingPort(port);
            return this;
        }

        public Builder usingAnyFreePort() {
            super.usingAnyFreePort();
            return this;
        }

        @Beta
        public Builder withEnvironment(Map<String, String> environment) {
            super.withEnvironment(environment);
            return this;
        }

        public Builder withLogFile(File logFile) {
            super.withLogFile(logFile);
            return this;
        }

        public ChromeDriverService build() {
            return (ChromeDriverService)super.build();
        }

        protected DriverService buildDriverService() throws IOException {
            return new ChromeDriverService(this.exe, this.port, this.environment, this.logFile);
        }
    }
}

