/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chrome;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chrome.ChromeProfile;
import org.openqa.selenium.internal.FileHandler;

public class ChromeExtension {
    public static final String CHROME_EXTENSION_DIRECTORY_PROPERTY = "webdriver.chrome.extensiondir";
    private static final String DEFAULT_EXTENSION_PATH = "/chrome-extension.zip";
    private static final String MANIFEST_FILE = "manifest.json";
    private static volatile File defaultExtensionDir;
    private final File directory;

    public ChromeExtension(File directory) throws WebDriverException {
        try {
            this.directory = ChromeExtension.checkExtensionForManifest(directory);
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    public ChromeExtension() {
        this(ChromeExtension.findChromeExtensionDir());
    }

    public File getDirectory() {
        return this.directory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File findChromeExtensionDir() {
        File directory = defaultExtensionDir;
        if (directory != null) return directory;
        Class<ChromeExtension> clazz = ChromeExtension.class;
        synchronized (ChromeExtension.class) {
            directory = defaultExtensionDir;
            if (directory != null) return directory;
            defaultExtensionDir = ChromeExtension.loadExtension();
            return defaultExtensionDir;
        }
    }

    private static File checkExtensionForManifest(File directory) throws IOException {
        if (!directory.isDirectory()) {
            throw new FileNotFoundException(String.format("The specified directory is not a Chrome extension directory: %s; Try setting %s", directory.getAbsolutePath(), CHROME_EXTENSION_DIRECTORY_PROPERTY));
        }
        File manifestFile = new File(directory, MANIFEST_FILE);
        if (!manifestFile.exists()) {
            File platformManifestFile = new File(directory, MANIFEST_FILE);
            if (!platformManifestFile.exists()) {
                throw new FileNotFoundException(String.format("The specified extension has no %s file: %s", MANIFEST_FILE, directory.getAbsolutePath()));
            }
            FileHandler.copy((File)platformManifestFile, (File)manifestFile);
        }
        return directory;
    }

    private static File loadExtension() {
        try {
            File extensionDir;
            String directory = System.getProperty(CHROME_EXTENSION_DIRECTORY_PROPERTY);
            if (directory != null && !"".equals(directory)) {
                extensionDir = new File(directory);
            } else {
                InputStream stream = ChromeProfile.class.getResourceAsStream(DEFAULT_EXTENSION_PATH);
                extensionDir = FileHandler.unzip((InputStream)stream);
            }
            return ChromeExtension.checkExtensionForManifest(extensionDir);
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
    }
}

