/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;

public class Multimap<K, V> {
    private final Map<K, Set<V>> map = new LinkedHashMap<K, Set<V>>();

    public Multimap() {
    }

    public Multimap(Multimap<K, V> source) {
        this.map.putAll(source.map);
    }

    public Multimap<K, V> put(K key, V value) {
        this.map.computeIfAbsent(key, __ -> new LinkedHashSet()).add(value);
        return this;
    }

    public Multimap<K, V> putAll(K key, Collection<V> values) {
        this.map.computeIfAbsent(key, __ -> new LinkedHashSet()).addAll(values);
        return this;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Map<K, Collection<V>> asMap() {
        return Collections.unmodifiableMap(this.map);
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public void forEach(BiConsumer<K, V> consumer) {
        this.map.forEach((? super K key, ? super V values) -> values.forEach((? super T value) -> consumer.accept(key, value)));
    }
}

