/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.ScriptKey;
import org.openqa.selenium.UnpinnedScriptKey;
import org.openqa.selenium.internal.Require;

public interface JavascriptExecutor {
    public Object executeScript(String var1, Object ... var2);

    public Object executeAsyncScript(String var1, Object ... var2);

    default public ScriptKey pin(String script) {
        Require.nonNull("Script to pin", script);
        return UnpinnedScriptKey.pin(this, script);
    }

    default public void unpin(ScriptKey key) {
        Require.nonNull("Key to unpin", key);
        Require.stateCondition(key instanceof UnpinnedScriptKey, "Script key should have been generated by this driver", new Object[0]);
        UnpinnedScriptKey.unpin(this, (UnpinnedScriptKey)key);
    }

    default public Set<ScriptKey> getPinnedScripts() {
        return Collections.unmodifiableSet(UnpinnedScriptKey.getPinnedScripts(this).stream().map(key -> key).collect(Collectors.toSet()));
    }

    default public Object executeScript(ScriptKey key, Object ... args) {
        Require.stateCondition(key instanceof UnpinnedScriptKey, "Script key should have been generated by this driver", new Object[0]);
        if (!this.getPinnedScripts().contains(key)) {
            throw new JavascriptException("Script is unpinned");
        }
        return this.executeScript(((UnpinnedScriptKey)key).getScript(), args);
    }
}

