/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Base64;
import org.openqa.selenium.WebDriverException;

public interface OutputType<T> {
    public static final OutputType<String> BASE64 = new OutputType<String>(){

        @Override
        public String convertFromBase64Png(String base64Png) {
            return base64Png;
        }

        @Override
        public String convertFromPngBytes(byte[] png) {
            return Base64.getEncoder().encodeToString(png);
        }

        public String toString() {
            return "OutputType.BASE64";
        }
    };
    public static final OutputType<byte[]> BYTES = new OutputType<byte[]>(){

        @Override
        public byte[] convertFromBase64Png(String base64Png) {
            return Base64.getMimeDecoder().decode(base64Png);
        }

        @Override
        public byte[] convertFromPngBytes(byte[] png) {
            return png;
        }

        public String toString() {
            return "OutputType.BYTES";
        }
    };
    public static final OutputType<File> FILE = new OutputType<File>(){

        @Override
        public File convertFromBase64Png(String base64Png) {
            return this.save((byte[])BYTES.convertFromBase64Png(base64Png));
        }

        @Override
        public File convertFromPngBytes(byte[] data) {
            return this.save(data);
        }

        private File save(byte[] data) {
            File file;
            File tmpFile = File.createTempFile("screenshot", ".png");
            tmpFile.deleteOnExit();
            FileOutputStream stream = new FileOutputStream(tmpFile);
            try {
                ((OutputStream)stream).write(data);
                file = tmpFile;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        try {
                            ((OutputStream)stream).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new WebDriverException(e);
                    }
                }
                catch (IOException e) {
                    throw new WebDriverException(e);
                }
            }
            ((OutputStream)stream).close();
            return file;
        }

        public String toString() {
            return "OutputType.FILE";
        }
    };

    public T convertFromBase64Png(String var1);

    public T convertFromPngBytes(byte[] var1);
}

