/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.logging.LogLevelMapping;
import org.openqa.selenium.logging.LoggingPreferences;

abstract class AbstractCapabilities
implements Capabilities {
    private final Map<String, Object> caps = new TreeMap<String, Object>();

    AbstractCapabilities() {
    }

    @Override
    public Platform getPlatform() {
        return Stream.of("platform", "platformName").map(this::getCapability).filter(Objects::nonNull).map(cap -> {
            if (cap instanceof Platform) {
                return (Platform)((Object)((Object)cap));
            }
            try {
                return Platform.fromString(String.valueOf(cap));
            }
            catch (WebDriverException e) {
                return null;
            }
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Override
    public Object getCapability(String capabilityName) {
        return this.caps.get(capabilityName);
    }

    protected void setCapability(String key, Object value) {
        Objects.requireNonNull(key, "Cannot set a capability without a name");
        if (value == null) {
            this.caps.remove(key);
            return;
        }
        if ("loggingPrefs".equals(key) && value instanceof Map) {
            LoggingPreferences prefs = new LoggingPreferences();
            Map prefsMap = (Map)value;
            for (String logType : prefsMap.keySet()) {
                prefs.enable(logType, LogLevelMapping.toLevel((String)prefsMap.get(logType)));
            }
            this.caps.put(key, prefs);
            return;
        }
        if ("platform".equals(key) && value instanceof String) {
            try {
                this.caps.put(key, (Object)Platform.fromString((String)value));
            }
            catch (WebDriverException e) {
                this.caps.put(key, value);
            }
            return;
        }
        if ("unexpectedAlertBehaviour".equals(key)) {
            this.caps.put("unexpectedAlertBehaviour", value);
            this.caps.put("unhandledPromptBehavior", value);
            return;
        }
        this.caps.put(key, value);
    }

    @Override
    public Set<String> getCapabilityNames() {
        return Collections.unmodifiableSet(this.caps.keySet());
    }

    @Override
    public Map<String, Object> asMap() {
        return Collections.unmodifiableMap(this.caps);
    }

    public Map<String, Object> toJson() {
        return this.asMap();
    }

    protected int amendHashCode() {
        return 0;
    }

    public int hashCode() {
        return Objects.hash(this.amendHashCode(), this.caps);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Capabilities)) {
            return false;
        }
        Capabilities that = (Capabilities)o;
        return this.asMap().equals(that.asMap());
    }

    public String toString() {
        IdentityHashMap<Object, String> seen = new IdentityHashMap<Object, String>();
        return "Capabilities " + this.abbreviate(seen, this.caps);
    }

    private String abbreviate(Map<Object, String> seen, Object stringify) {
        if (stringify == null) {
            return "null";
        }
        StringBuilder value = new StringBuilder();
        if (stringify.getClass().isArray()) {
            value.append("[");
            value.append(Stream.of((Object[])stringify).map(item -> this.abbreviate(seen, item)).collect(Collectors.joining(", ")));
            value.append("]");
        } else if (stringify instanceof Collection) {
            value.append("[");
            value.append(((Collection)stringify).stream().map(item -> this.abbreviate(seen, item)).collect(Collectors.joining(", ")));
            value.append("]");
        } else if (stringify instanceof Map) {
            value.append("{");
            value.append(((Map)stringify).entrySet().stream().sorted(Comparator.comparing(entry -> String.valueOf(entry.getKey()))).map(entry -> String.valueOf(entry.getKey()) + ": " + this.abbreviate(seen, entry.getValue())).collect(Collectors.joining(", ")));
            value.append("}");
        } else {
            String s = String.valueOf(stringify);
            if (s.length() > 30) {
                value.append(s, 0, 27).append("...");
            } else {
                value.append(s);
            }
        }
        seen.put(stringify, value.toString());
        return value.toString();
    }
}

