/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.Map;

public class Proxy {
    private ProxyType proxyType = ProxyType.UNSPECIFIED;
    private boolean autodetect = false;
    private String ftpProxy;
    private String httpProxy;
    private String noProxy;
    private String sslProxy;
    private String socksProxy;
    private String socksUsername;
    private String socksPassword;
    private String proxyAutoconfigUrl;

    public Proxy() {
    }

    public Proxy(Map<String, ?> raw) {
        if (raw.containsKey("proxyType") && raw.get("proxyType") != null) {
            this.setProxyType(ProxyType.valueOf(((String)raw.get("proxyType")).toUpperCase()));
        }
        if (raw.containsKey("ftpProxy") && raw.get("ftpProxy") != null) {
            this.setFtpProxy((String)raw.get("ftpProxy"));
        }
        if (raw.containsKey("httpProxy") && raw.get("httpProxy") != null) {
            this.setHttpProxy((String)raw.get("httpProxy"));
        }
        if (raw.containsKey("noProxy") && raw.get("noProxy") != null) {
            this.setNoProxy((String)raw.get("noProxy"));
        }
        if (raw.containsKey("sslProxy") && raw.get("sslProxy") != null) {
            this.setSslProxy((String)raw.get("sslProxy"));
        }
        if (raw.containsKey("socksProxy") && raw.get("socksProxy") != null) {
            this.setSocksProxy((String)raw.get("socksProxy"));
        }
        if (raw.containsKey("socksUsername") && raw.get("socksUsername") != null) {
            this.setSocksUsername((String)raw.get("socksUsername"));
        }
        if (raw.containsKey("socksPassword") && raw.get("socksPassword") != null) {
            this.setSocksPassword((String)raw.get("socksPassword"));
        }
        if (raw.containsKey("proxyAutoconfigUrl") && raw.get("proxyAutoconfigUrl") != null) {
            this.setProxyAutoconfigUrl((String)raw.get("proxyAutoconfigUrl"));
        }
        if (raw.containsKey("autodetect") && raw.get("autodetect") != null) {
            this.setAutodetect((Boolean)raw.get("autodetect"));
        }
    }

    public ProxyType getProxyType() {
        return this.proxyType;
    }

    public Proxy setProxyType(ProxyType proxyType) {
        this.verifyProxyTypeCompatibility(proxyType);
        this.proxyType = proxyType;
        return this;
    }

    public boolean isAutodetect() {
        return this.autodetect;
    }

    public Proxy setAutodetect(boolean autodetect) {
        if (this.autodetect == autodetect) {
            return this;
        }
        if (autodetect) {
            this.verifyProxyTypeCompatibility(ProxyType.AUTODETECT);
            this.proxyType = ProxyType.AUTODETECT;
        } else {
            this.proxyType = ProxyType.UNSPECIFIED;
        }
        this.autodetect = autodetect;
        return this;
    }

    public String getFtpProxy() {
        return this.ftpProxy;
    }

    public Proxy setFtpProxy(String ftpProxy) {
        this.verifyProxyTypeCompatibility(ProxyType.MANUAL);
        this.proxyType = ProxyType.MANUAL;
        this.ftpProxy = ftpProxy;
        return this;
    }

    public String getHttpProxy() {
        return this.httpProxy;
    }

    public Proxy setHttpProxy(String httpProxy) {
        this.verifyProxyTypeCompatibility(ProxyType.MANUAL);
        this.proxyType = ProxyType.MANUAL;
        this.httpProxy = httpProxy;
        return this;
    }

    public String getNoProxy() {
        return this.noProxy;
    }

    public Proxy setNoProxy(String noProxy) {
        this.verifyProxyTypeCompatibility(ProxyType.MANUAL);
        this.proxyType = ProxyType.MANUAL;
        this.noProxy = noProxy;
        return this;
    }

    public String getSslProxy() {
        return this.sslProxy;
    }

    public Proxy setSslProxy(String sslProxy) {
        this.verifyProxyTypeCompatibility(ProxyType.MANUAL);
        this.proxyType = ProxyType.MANUAL;
        this.sslProxy = sslProxy;
        return this;
    }

    public String getSocksProxy() {
        return this.socksProxy;
    }

    public Proxy setSocksProxy(String socksProxy) {
        this.verifyProxyTypeCompatibility(ProxyType.MANUAL);
        this.proxyType = ProxyType.MANUAL;
        this.socksProxy = socksProxy;
        return this;
    }

    public String getSocksUsername() {
        return this.socksUsername;
    }

    public Proxy setSocksUsername(String username) {
        this.verifyProxyTypeCompatibility(ProxyType.MANUAL);
        this.proxyType = ProxyType.MANUAL;
        this.socksUsername = username;
        return this;
    }

    public String getSocksPassword() {
        return this.socksPassword;
    }

    public Proxy setSocksPassword(String password) {
        this.verifyProxyTypeCompatibility(ProxyType.MANUAL);
        this.proxyType = ProxyType.MANUAL;
        this.socksPassword = password;
        return this;
    }

    public String getProxyAutoconfigUrl() {
        return this.proxyAutoconfigUrl;
    }

    public Proxy setProxyAutoconfigUrl(String proxyAutoconfigUrl) {
        this.verifyProxyTypeCompatibility(ProxyType.PAC);
        this.proxyType = ProxyType.PAC;
        this.proxyAutoconfigUrl = proxyAutoconfigUrl;
        return this;
    }

    private void verifyProxyTypeCompatibility(ProxyType compatibleProxy) {
        if (this.proxyType != ProxyType.UNSPECIFIED && this.proxyType != compatibleProxy) {
            throw new IllegalStateException(String.format("Specified proxy type (%s) not compatible with current setting (%s)", new Object[]{compatibleProxy, this.proxyType}));
        }
    }

    public static enum ProxyType {
        DIRECT,
        MANUAL,
        PAC,
        RESERVED_1,
        AUTODETECT,
        SYSTEM,
        UNSPECIFIED;

    }
}

