/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Proxy {
    private ProxyType proxyType = ProxyType.UNSPECIFIED;
    private boolean autodetect = false;
    private String ftpProxy;
    private String httpProxy;
    private String noProxy;
    private String proxyAutoconfigUrl;
    private String sslProxy;

    public Proxy() {
    }

    public Proxy(Map<String, ?> raw) {
        if (raw.containsKey("proxyType") && raw.get("proxyType") != null) {
            this.setProxyType(ProxyType.valueOf((String)raw.get("proxyType")));
        }
        if (raw.containsKey("ftpProxy") && raw.get("ftpProxy") != null) {
            this.setFtpProxy((String)raw.get("ftpProxy"));
        }
        if (raw.containsKey("httpProxy") && raw.get("httpProxy") != null) {
            this.setHttpProxy((String)raw.get("httpProxy"));
        }
        if (raw.containsKey("noProxy") && raw.get("noProxy") != null) {
            this.setNoProxy((String)raw.get("noProxy"));
        }
        if (raw.containsKey("proxyAutoconfigUrl") && raw.get("proxyAutoconfigUrl") != null) {
            this.setProxyAutoconfigUrl((String)raw.get("proxyAutoconfigUrl"));
        }
        if (raw.containsKey("sslProxy") && raw.get("sslProxy") != null) {
            this.setSslProxy((String)raw.get("sslProxy"));
        }
        if (raw.containsKey("autodetect") && raw.get("autodetect") != null) {
            this.setAutodetect((Boolean)raw.get("autodetect"));
        }
    }

    public ProxyType getProxyType() {
        return this.proxyType;
    }

    public Proxy setProxyType(ProxyType proxyType) {
        this.verifyProxyTypeCompatilibily(ProxyType.AUTODETECT);
        this.proxyType = proxyType;
        return this;
    }

    public boolean isAutodetect() {
        return this.autodetect;
    }

    public Proxy setAutodetect(boolean autodetect) {
        if (this.autodetect == autodetect) {
            return this;
        }
        this.verifyProxyTypeCompatilibily(ProxyType.AUTODETECT);
        this.proxyType = ProxyType.AUTODETECT;
        this.autodetect = autodetect;
        return this;
    }

    public String getFtpProxy() {
        return this.ftpProxy;
    }

    public Proxy setFtpProxy(String ftpProxy) {
        this.verifyProxyTypeCompatilibily(ProxyType.MANUAL);
        this.proxyType = ProxyType.MANUAL;
        this.ftpProxy = ftpProxy;
        return this;
    }

    public String getHttpProxy() {
        return this.httpProxy;
    }

    public Proxy setHttpProxy(String httpProxy) {
        this.verifyProxyTypeCompatilibily(ProxyType.MANUAL);
        this.proxyType = ProxyType.MANUAL;
        this.httpProxy = httpProxy;
        return this;
    }

    public String getNoProxy() {
        return this.noProxy;
    }

    public Proxy setNoProxy(String noProxy) {
        this.verifyProxyTypeCompatilibily(ProxyType.MANUAL);
        this.proxyType = ProxyType.MANUAL;
        this.noProxy = noProxy;
        return this;
    }

    public String getProxyAutoconfigUrl() {
        return this.proxyAutoconfigUrl;
    }

    public Proxy setProxyAutoconfigUrl(String proxyAutoconfigUrl) {
        this.verifyProxyTypeCompatilibily(ProxyType.PAC);
        this.proxyType = ProxyType.PAC;
        this.proxyAutoconfigUrl = proxyAutoconfigUrl;
        return this;
    }

    public String getSslProxy() {
        return this.sslProxy;
    }

    public Proxy setSslProxy(String sslProxy) {
        this.verifyProxyTypeCompatilibily(ProxyType.MANUAL);
        this.proxyType = ProxyType.MANUAL;
        this.sslProxy = sslProxy;
        return this;
    }

    private void verifyProxyTypeCompatilibily(ProxyType compatibleProxy) {
        if (this.proxyType != ProxyType.UNSPECIFIED && this.proxyType != compatibleProxy) {
            throw new IllegalStateException(String.format("Specified proxy type (%s) not compatible with current setting (%s)", new Object[]{compatibleProxy, this.proxyType}));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProxyType {
        DIRECT,
        MANUAL,
        PAC,
        RESERVED_1,
        AUTODETECT,
        SYSTEM,
        UNSPECIFIED;

    }
}

