/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.android.library;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Picture;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Environment;
import android.os.Looper;
import android.provider.Settings;
import android.view.View;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.WebView;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.selenium.Alert;
import org.openqa.selenium.Beta;
import org.openqa.selenium.By;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.HasTouchScreen;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Rotatable;
import org.openqa.selenium.ScreenOrientation;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.TouchScreen;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.android.library.AlertManager;
import org.openqa.selenium.android.library.AndroidAtoms;
import org.openqa.selenium.android.library.AndroidLocalStorage;
import org.openqa.selenium.android.library.AndroidLogs;
import org.openqa.selenium.android.library.AndroidSessionStorage;
import org.openqa.selenium.android.library.AndroidTouchScreen;
import org.openqa.selenium.android.library.AndroidWebElement;
import org.openqa.selenium.android.library.ChromeClientWrapper;
import org.openqa.selenium.android.library.DefaultChromeClient;
import org.openqa.selenium.android.library.DefaultViewClient;
import org.openqa.selenium.android.library.DefaultWebViewFactory;
import org.openqa.selenium.android.library.DomWindow;
import org.openqa.selenium.android.library.JavascriptExecutor;
import org.openqa.selenium.android.library.JavascriptResultNotifier;
import org.openqa.selenium.android.library.Logger;
import org.openqa.selenium.android.library.NetworkStateHandler;
import org.openqa.selenium.android.library.SessionCookieManager;
import org.openqa.selenium.android.library.ViewAdapter;
import org.openqa.selenium.android.library.ViewClientWrapper;
import org.openqa.selenium.android.library.ViewFactory;
import org.openqa.selenium.android.library.WebDriverView;
import org.openqa.selenium.android.library.WebDriverViewManager;
import org.openqa.selenium.html5.AppCacheStatus;
import org.openqa.selenium.html5.ApplicationCache;
import org.openqa.selenium.html5.BrowserConnection;
import org.openqa.selenium.html5.LocalStorage;
import org.openqa.selenium.html5.Location;
import org.openqa.selenium.html5.LocationContext;
import org.openqa.selenium.html5.SessionStorage;
import org.openqa.selenium.html5.WebStorage;
import org.openqa.selenium.internal.Base64Encoder;
import org.openqa.selenium.internal.FindsByClassName;
import org.openqa.selenium.internal.FindsByCssSelector;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByLinkText;
import org.openqa.selenium.internal.FindsByName;
import org.openqa.selenium.internal.FindsByTagName;
import org.openqa.selenium.internal.FindsByXPath;
import org.openqa.selenium.internal.WrapsElement;
import org.openqa.selenium.logging.Logs;

public class AndroidWebDriver
implements WebDriver,
SearchContext,
org.openqa.selenium.JavascriptExecutor,
TakesScreenshot,
Rotatable,
BrowserConnection,
HasTouchScreen,
WebStorage,
LocationContext,
LocationListener,
ApplicationCache {
    private static final String ELEMENT_KEY = "ELEMENT";
    private static final String WINDOW_KEY = "WINDOW";
    private static final String STATUS = "status";
    private static final String VALUE = "value";
    private AndroidWebElement element;
    private DomWindow currentWindowOrFrame;
    private long implicitWait = 0L;
    private Map<String, AndroidWebElement> store;
    private AndroidTouchScreen touchScreen;
    private AndroidNavigation navigation;
    private AndroidOptions options;
    private AndroidLocalStorage localStorage;
    private AndroidSessionStorage sessionStorage;
    private AndroidTargetLocator targetLocator;
    private AndroidFindBy findBy;
    private AndroidLogs logs;
    private volatile String lastUrlLoaded;
    private SessionCookieManager sessionCookieManager;
    private ViewAdapter view;
    private WebDriverViewManager viewManager;
    private final Object syncObject = new Object();
    private volatile boolean pageDoneLoading;
    private NetworkStateHandler networkHandler;
    private Activity activity;
    private volatile boolean editAreaHasFocus;
    private volatile String result;
    private volatile boolean resultReady;
    private static final long LOADING_TIMEOUT = 30000L;
    private static final long START_LOADING_TIMEOUT = 700L;
    static final long RESPONSE_TIMEOUT = 10000L;
    private static final long FOCUS_TIMEOUT = 1000L;
    private static final long POLLING_INTERVAL = 50L;
    static final long UI_TIMEOUT = 3000L;
    private boolean acceptSslCerts;
    private volatile boolean pageStartedLoading;
    private boolean done = false;
    private Supplier<LocationManager> locManagerSupplier;
    private String locationProvider;
    private JavascriptResultNotifier notifier = new JavascriptResultNotifier(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyResultReady(String updated) {
            Object object = AndroidWebDriver.this.syncObject;
            synchronized (object) {
                AndroidWebDriver.this.result = updated;
                AndroidWebDriver.this.resultReady = true;
                AndroidWebDriver.this.syncObject.notify();
            }
        }
    };

    private AndroidWebElement getOrCreateWebElement(String id) {
        if (this.store.get(id) != null) {
            return this.store.get(id);
        }
        AndroidWebElement toReturn = new AndroidWebElement(this, id);
        this.store.put(id, toReturn);
        return toReturn;
    }

    public void setAcceptSslCerts(boolean accept) {
        this.acceptSslCerts = accept;
    }

    public boolean getAcceptSslCerts() {
        return this.acceptSslCerts;
    }

    private void initDriverState() {
        this.store = Maps.newHashMap();
        this.findBy = new AndroidFindBy();
        this.currentWindowOrFrame = new DomWindow("");
        this.store = Maps.newHashMap();
        this.touchScreen = new AndroidTouchScreen(this);
        this.navigation = new AndroidNavigation();
        this.options = new AndroidOptions();
        this.element = this.getOrCreateWebElement("");
        this.localStorage = new AndroidLocalStorage(this);
        this.sessionStorage = new AndroidSessionStorage(this);
        this.targetLocator = new AndroidTargetLocator();
        this.viewManager = new WebDriverViewManager();
        this.logs = new AndroidLogs();
        Looper.prepare();
        try {
            this.locationProvider = "gps";
            final LocationManager locManager = (LocationManager)this.activity.getSystemService("location");
            this.locManagerSupplier = new Supplier<LocationManager>(){

                public LocationManager get() {
                    return locManager;
                }
            };
            locManager.addTestProvider(this.locationProvider, true, true, true, true, true, true, true, 0, 5);
            locManager.setTestProviderEnabled(this.locationProvider, true);
            locManager.requestLocationUpdates(this.locationProvider, 0L, 0.0f, (LocationListener)this);
        }
        catch (SecurityException e) {
            this.locManagerSupplier = new Supplier<LocationManager>(){

                public LocationManager get() {
                    throw new IllegalStateException("The permission to ALLOW_MOCK_LOCATION needs to be set on your android device, but currently is not. Cannot perform location actions without this permission.");
                }
            };
        }
    }

    private void initCookiesState() {
        CookieSyncManager.createInstance((Context)this.activity);
        this.sessionCookieManager = new SessionCookieManager();
        CookieManager cookieManager = CookieManager.getInstance();
        cookieManager.removeAllCookie();
    }

    public AndroidWebDriver(Activity activity) {
        this.activity = activity;
        this.initDriverState();
        ChromeClientWrapper chromeWrapper = new ChromeClientWrapper("android.webkit.WebChromeClient", new DefaultChromeClient());
        ViewClientWrapper viewClientWrapper = new ViewClientWrapper("android.webkit.WebViewClient", new DefaultViewClient());
        WebDriverView wdview = new WebDriverView(this, new DefaultWebViewFactory(), viewClientWrapper, chromeWrapper, null);
        this.newWebView(true, wdview);
        this.initCookiesState();
        this.networkHandler = new NetworkStateHandler(activity, this.view);
    }

    public AndroidWebDriver(Activity activity, ViewFactory viewFactory, ViewClientWrapper viewClient, ChromeClientWrapper chromeClient) {
        this.activity = activity;
        this.initDriverState();
        WebDriverView wdview = new WebDriverView(this, viewFactory, viewClient, chromeClient, null);
        this.newWebView(true, wdview);
        this.initCookiesState();
        this.networkHandler = new NetworkStateHandler(activity, this.view);
    }

    public AndroidWebDriver(Activity activity, ViewFactory viewFactory, ViewClientWrapper viewClient, ChromeClientWrapper chromeClient, View.OnFocusChangeListener focusListener) {
        this.activity = activity;
        this.initDriverState();
        WebDriverView wdview = new WebDriverView(this, viewFactory, viewClient, chromeClient, focusListener);
        this.newWebView(true, wdview);
        this.initCookiesState();
        this.networkHandler = new NetworkStateHandler(activity, this.view);
    }

    String getLastUrlLoaded() {
        return this.lastUrlLoaded;
    }

    void setLastUrlLoaded(String url) {
        this.lastUrlLoaded = url;
    }

    void setEditAreaHasFocus(boolean focused) {
        this.editAreaHasFocus = focused;
    }

    boolean getEditAreaHasFocus() {
        return this.editAreaHasFocus;
    }

    void resetPageIsLoading() {
        this.pageStartedLoading = false;
        this.pageDoneLoading = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyPageStartedLoading() {
        Object object = this.syncObject;
        synchronized (object) {
            this.pageStartedLoading = true;
            this.pageDoneLoading = false;
            this.syncObject.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyPageDoneLoading() {
        Object object = this.syncObject;
        synchronized (object) {
            this.pageDoneLoading = true;
            this.syncObject.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForPageToLoad() {
        Object object = this.syncObject;
        synchronized (object) {
            long timeout = System.currentTimeMillis() + 700L;
            while (!this.pageStartedLoading && System.currentTimeMillis() < timeout) {
                try {
                    this.syncObject.wait(50L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException();
                }
            }
            long end = System.currentTimeMillis() + 30000L;
            while (!this.pageDoneLoading && this.pageStartedLoading && System.currentTimeMillis() < end) {
                try {
                    this.syncObject.wait(30000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    void waitUntilEditAreaHasFocus() {
        long timeout = System.currentTimeMillis() + 1000L;
        while (!this.editAreaHasFocus && System.currentTimeMillis() < timeout) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public WebView getWebView() {
        if (this.view.getUnderlyingView() instanceof WebView) {
            return (WebView)this.view.getUnderlyingView();
        }
        throw new WebDriverException("This WebDriver instance is not using a WebView!");
    }

    public Object getView() {
        return this.view.getUnderlyingView();
    }

    void newWebView(boolean newDriver, final WebDriverView wdview) {
        if (newDriver) {
            this.quit();
        }
        long start = System.currentTimeMillis();
        long end = start + 3000L;
        this.done = false;
        this.activity.runOnUiThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = AndroidWebDriver.this.syncObject;
                synchronized (object) {
                    ViewAdapter newView = wdview.create();
                    AndroidWebDriver.this.view = newView;
                    AndroidWebDriver.this.viewManager.addView(AndroidWebDriver.this.view);
                    AndroidWebDriver.this.activity.setContentView((View)AndroidWebDriver.this.view.getUnderlyingView());
                    AndroidWebDriver.this.done = true;
                    AndroidWebDriver.this.syncObject.notify();
                }
            }
        });
        this.waitForDone(end, 3000L, "Failed to create WebView.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForDone(long end, long timeout, String error) {
        Object object = this.syncObject;
        synchronized (object) {
            while (!this.done && System.currentTimeMillis() < end) {
                try {
                    this.syncObject.wait(timeout);
                }
                catch (InterruptedException e) {
                    throw new WebDriverException(error, (Throwable)e);
                }
            }
        }
    }

    WebDriverViewManager getViewManager() {
        return this.viewManager;
    }

    public Activity getActivity() {
        return this.activity;
    }

    public String getCurrentUrl() {
        if (this.view == null) {
            throw new WebDriverException("No open windows.");
        }
        this.done = false;
        long end = System.currentTimeMillis() + 3000L;
        final String[] url = new String[1];
        this.activity.runOnUiThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = AndroidWebDriver.this.syncObject;
                synchronized (object) {
                    url[0] = AndroidWebDriver.this.view.getUrl();
                    AndroidWebDriver.this.done = true;
                    AndroidWebDriver.this.syncObject.notify();
                }
            }
        });
        this.waitForDone(end, 3000L, "Failed to get current url.");
        return url[0];
    }

    public String getTitle() {
        if (this.view == null) {
            throw new WebDriverException("No open windows.");
        }
        long end = System.currentTimeMillis() + 3000L;
        final String[] title = new String[1];
        this.done = false;
        this.activity.runOnUiThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = AndroidWebDriver.this.syncObject;
                synchronized (object) {
                    title[0] = AndroidWebDriver.this.view.getTitle();
                    AndroidWebDriver.this.done = true;
                    AndroidWebDriver.this.syncObject.notify();
                }
            }
        });
        this.waitForDone(end, 3000L, "Failed to get title");
        return title[0];
    }

    public void get(String url) {
        this.navigation.to(url);
    }

    public String getPageSource() {
        return (String)this.executeScript("return (new XMLSerializer()).serializeToString(document.documentElement);", new Object[0]);
    }

    public void close() {
        if (this.view == null) {
            throw new WebDriverException("No open windows.");
        }
        AlertManager.removeAlertForView(this.view);
        this.done = false;
        long end = System.currentTimeMillis() + 10000L;
        this.activity.runOnUiThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = AndroidWebDriver.this.syncObject;
                synchronized (object) {
                    AndroidWebDriver.this.view.destroy();
                    AndroidWebDriver.this.viewManager.removeView(AndroidWebDriver.this.view);
                    AndroidWebDriver.this.done = true;
                    AndroidWebDriver.this.syncObject.notify();
                }
            }
        });
        this.waitForDone(end, 10000L, "Failed to close window.");
        this.view = null;
    }

    public void quit() {
        AlertManager.removeAllAlerts();
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AndroidWebDriver.this.viewManager.closeAll();
                AndroidWebDriver.this.view = null;
            }
        });
    }

    public WebElement findElement(By by) {
        long start = System.currentTimeMillis();
        while (true) {
            try {
                return by.findElement((SearchContext)this.findBy);
            }
            catch (NoSuchElementException e) {
                if (System.currentTimeMillis() - start > this.implicitWait) {
                    throw e;
                }
                AndroidWebDriver.sleepQuietly(100L);
                continue;
            }
            break;
        }
    }

    public List<WebElement> findElements(By by) {
        long start = System.currentTimeMillis();
        List found = by.findElements((SearchContext)this.findBy);
        while (found.isEmpty() && System.currentTimeMillis() - start <= this.implicitWait) {
            AndroidWebDriver.sleepQuietly(100L);
            found = by.findElements((SearchContext)this.findBy);
        }
        return found;
    }

    public AppCacheStatus getStatus() {
        Long scriptRes = (Long)this.executeRawScript("(" + AndroidAtoms.GET_APPCACHE_STATUS.getValue() + ")()");
        return AppCacheStatus.getEnum((int)scriptRes.intValue());
    }

    private static void sleepQuietly(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException cause) {
            Thread.currentThread().interrupt();
            throw new WebDriverException((Throwable)cause);
        }
    }

    public Set<String> getWindowHandles() {
        return this.viewManager.getAllHandles();
    }

    public String getWindowHandle() {
        String r = this.viewManager.getWindowHandle(this.view);
        if (r == null) {
            throw new WebDriverException("FATAL ERROR HANDLE IS NULL");
        }
        return r;
    }

    public WebDriver.TargetLocator switchTo() {
        return this.targetLocator;
    }

    public LocalStorage getLocalStorage() {
        return this.localStorage;
    }

    public SessionStorage getSessionStorage() {
        return this.sessionStorage;
    }

    public WebDriver.Navigation navigate() {
        return this.navigation;
    }

    public boolean isJavascriptEnabled() {
        return true;
    }

    public Object executeScript(String script, Object ... args) {
        return this.injectJavascript(script, false, args);
    }

    public Object executeAsyncScript(String script, Object ... args) {
        throw new UnsupportedOperationException("This is feature will be implemented soon!");
    }

    private String convertToJsArgs(Object ... args) {
        StringBuilder toReturn = new StringBuilder();
        int length = args.length;
        for (int i = 0; i < length; ++i) {
            toReturn.append(i > 0 ? "," : "");
            if (args[i] instanceof List) {
                toReturn.append("[");
                List aList = (List)args[i];
                for (int j = 0; j < aList.size(); ++j) {
                    String comma = j == 0 ? "" : ",";
                    toReturn.append(comma + this.convertToJsArgs(aList.get(j)));
                }
                toReturn.append("]");
                continue;
            }
            if (args[i] instanceof Map) {
                Map aMap = (Map)args[i];
                String toAdd = "{";
                for (Object key : aMap.keySet()) {
                    toAdd = toAdd + key + ":" + this.convertToJsArgs(aMap.get(key)) + ",";
                }
                toReturn.append(toAdd.substring(0, toAdd.length() - 1) + "}");
                continue;
            }
            if (args[i] instanceof WebElement) {
                toReturn.append("{\"ELEMENT\":\"" + ((AndroidWebElement)args[i]).getId() + "\"}");
                continue;
            }
            if (args[i] instanceof DomWindow) {
                toReturn.append("{\"WINDOW\":\"" + ((DomWindow)args[i]).getKey() + "\"}");
                continue;
            }
            if (args[i] instanceof Number || args[i] instanceof Boolean) {
                toReturn.append(String.valueOf(args[i]));
                continue;
            }
            if (args[i] instanceof String) {
                toReturn.append(AndroidWebDriver.escapeAndQuote((String)args[i]));
                continue;
            }
            throw new IllegalArgumentException("Javascript arguments can be a Number, a Boolean, a String, a WebElement, or a List or a Map of those. Got: " + (args[i] == null ? "null" : args[i].getClass() + ", value: " + args[i].toString()));
        }
        return toReturn.toString();
    }

    private static String escapeAndQuote(String toWrap) {
        StringBuilder toReturn = new StringBuilder("\"");
        for (int i = 0; i < toWrap.length(); ++i) {
            char c = toWrap.charAt(i);
            if (c == '\"') {
                toReturn.append("\\\"");
                continue;
            }
            if (c == '\\') {
                toReturn.append("\\\\");
                continue;
            }
            toReturn.append(c);
        }
        toReturn.append("\"");
        return toReturn.toString();
    }

    void writeTo(String name, String toWrite) {
        try {
            File f = new File(Environment.getExternalStorageDirectory(), name);
            FileWriter w = new FileWriter(f);
            w.append(toWrite);
            w.flush();
            w.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Object executeRawScript(String toExecute) {
        String result = null;
        result = this.executeJavascriptInWebView("window.webdriver.resultMethod(" + toExecute + ")");
        if (result == null || "undefined".equals(result)) {
            return null;
        }
        try {
            JSONObject json = new JSONObject(result);
            this.throwIfError(json);
            Object value = json.get(VALUE);
            return this.convertJsonToJavaObject(value);
        }
        catch (JSONException e) {
            throw new RuntimeException("Failed to parse JavaScript result: " + result.toString(), e);
        }
    }

    Object executeAtom(String toExecute, Object ... args) {
        String scriptInWindow = "(function(){  var win; try{win=" + this.getWindowString() + "}catch(e){win=window;}" + "with(win){return (" + toExecute + ")(" + this.convertToJsArgs(args) + ")}})()";
        return this.executeRawScript(scriptInWindow);
    }

    private String getWindowString() {
        String window = "";
        if (!this.currentWindowOrFrame.getKey().equals("")) {
            window = "document['$wdc_']['" + this.currentWindowOrFrame.getKey() + "'] ||";
        }
        window = window + "window;";
        return window;
    }

    Object injectJavascript(String toExecute, boolean isAsync, Object ... args) {
        String executeScript = AndroidAtoms.EXECUTE_SCRIPT.getValue();
        toExecute = "var win_context; try{win_context= " + this.getWindowString() + "}catch(e){" + "win_context=window;}with(win_context){" + toExecute + "}";
        String wrappedScript = "(function(){var win; try{win=" + this.getWindowString() + "}catch(e){win=window}" + "with(win){return (" + executeScript + ")(" + AndroidWebDriver.escapeAndQuote(toExecute) + ", [" + this.convertToJsArgs(args) + "], true)}})()";
        return this.executeRawScript(wrappedScript);
    }

    private Object convertJsonToJavaObject(Object toConvert) {
        try {
            if (toConvert == null || toConvert.equals(null) || "undefined".equals(toConvert) || "null".equals(toConvert)) {
                return null;
            }
            if (toConvert instanceof Boolean) {
                return toConvert;
            }
            if (toConvert instanceof Double || toConvert instanceof Float) {
                return Double.valueOf(String.valueOf(toConvert));
            }
            if (toConvert instanceof Integer || toConvert instanceof Long) {
                return Long.valueOf(String.valueOf(toConvert));
            }
            if (toConvert instanceof JSONArray) {
                return this.convertJsonArrayToList((JSONArray)toConvert);
            }
            if (toConvert instanceof JSONObject) {
                JSONObject map = (JSONObject)toConvert;
                if (map.opt(ELEMENT_KEY) != null) {
                    return this.getOrCreateWebElement((String)map.get(ELEMENT_KEY));
                }
                if (map.opt(WINDOW_KEY) != null) {
                    return new DomWindow((String)map.get(WINDOW_KEY));
                }
                return this.convertJsonObjectToMap(map);
            }
            return toConvert.toString();
        }
        catch (JSONException e) {
            throw new RuntimeException("Failed to parse JavaScript result: " + toConvert.toString(), e);
        }
    }

    private List<Object> convertJsonArrayToList(JSONArray json) {
        ArrayList toReturn = Lists.newArrayList();
        for (int i = 0; i < json.length(); ++i) {
            try {
                toReturn.add(this.convertJsonToJavaObject(json.get(i)));
                continue;
            }
            catch (JSONException e) {
                throw new RuntimeException("Failed to parse JSON: " + json.toString(), e);
            }
        }
        return toReturn;
    }

    private Map<Object, Object> convertJsonObjectToMap(JSONObject json) {
        HashMap toReturn = Maps.newHashMap();
        Iterator it = json.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            try {
                Object value = json.get(key);
                toReturn.put(this.convertJsonToJavaObject(key), this.convertJsonToJavaObject(value));
            }
            catch (JSONException e) {
                throw new RuntimeException("Failed to parse JSON:" + json.toString(), e);
            }
        }
        return toReturn;
    }

    private void throwIfError(JSONObject jsonObject) {
        String errorMsg;
        int status;
        try {
            status = (Integer)jsonObject.get(STATUS);
            errorMsg = String.valueOf(jsonObject.get(VALUE));
        }
        catch (JSONException e) {
            throw new RuntimeException("Failed to parse JSON Object: " + jsonObject, e);
        }
        switch (status) {
            case 0: {
                return;
            }
            case 7: {
                throw new NoSuchElementException("Could not find WebElement.");
            }
            case 10: {
                throw new StaleElementReferenceException("WebElement is stale.");
            }
        }
        if (jsonObject.toString().contains("Result of expression 'd.evaluate' [undefined] is not a function.")) {
            throw new WebDriverException("You are using a version of Android WebDriver APK compatible with ICS SDKs or more recent SDKs. For more info take a look at http://code.google.com/p/selenium/wiki/AndroidDriver#Supported_Platforms. Error: " + jsonObject.toString());
        }
        throw new WebDriverException("Error: " + errorMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeJavascriptInWebView(final String script) {
        if (this.view == null) {
            throw new WebDriverException("No open windows.");
        }
        this.result = null;
        this.resultReady = false;
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                JavascriptExecutor.executeJs(AndroidWebDriver.this.view, AndroidWebDriver.this.notifier, script);
            }
        });
        long timeout = System.currentTimeMillis() + 10000L;
        Object object = this.syncObject;
        synchronized (object) {
            while (!this.resultReady && System.currentTimeMillis() < timeout) {
                try {
                    this.syncObject.wait(10000L);
                }
                catch (InterruptedException e) {
                    throw new WebDriverException((Throwable)e);
                }
            }
            return this.result;
        }
    }

    protected Object processJsonObject(Object res) throws JSONException {
        if (res instanceof JSONArray) {
            return this.convertJsonArray2List((JSONArray)res);
        }
        if ("undefined".equals(res)) {
            return null;
        }
        return res;
    }

    private List<Object> convertJsonArray2List(JSONArray arr) throws JSONException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < arr.length(); ++i) {
            list.add(this.processJsonObject(arr.get(i)));
        }
        return list;
    }

    public void setProxy(String host, int port) {
        if (host != null && host.length() > 0) {
            System.getProperties().put("proxySet", "true");
            System.getProperties().put("proxyHost", host);
            System.getProperties().put("proxyPort", (Object)port);
        }
    }

    public WebDriver.Options manage() {
        return this.options;
    }

    public Location location() {
        android.location.Location loc = ((LocationManager)this.locManagerSupplier.get()).getLastKnownLocation(this.locationProvider);
        return new Location(loc.getLatitude(), loc.getLongitude(), loc.getAltitude());
    }

    public void setLocation(Location loc) {
        android.location.Location location = new android.location.Location(this.locationProvider);
        location.setLatitude(loc.getLatitude());
        location.setLongitude(loc.getLongitude());
        location.setAltitude(loc.getAltitude());
        location.setTime(System.currentTimeMillis());
        ((LocationManager)this.locManagerSupplier.get()).setTestProviderLocation(this.locationProvider, location);
    }

    public void onLocationChanged(android.location.Location location) {
        Logger.log(Level.WARNING, AndroidWebDriver.class.getName(), "onLocationChanged", "New location: " + location.toString());
    }

    public void onStatusChanged(String s, int i, Bundle bundle) {
    }

    public void onProviderEnabled(String s) {
    }

    public void onProviderDisabled(String s) {
    }

    private byte[] takeScreenshot() {
        if (this.view == null) {
            throw new WebDriverException("No open windows.");
        }
        this.done = false;
        long end = System.currentTimeMillis() + 10000L;
        final byte[][] rawPng = new byte[1][1];
        this.activity.runOnUiThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = AndroidWebDriver.this.syncObject;
                synchronized (object) {
                    Picture pic = AndroidWebDriver.this.view.capturePicture();
                    Bitmap raw = Bitmap.createBitmap((int)pic.getWidth(), (int)pic.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
                    Canvas cv = new Canvas(raw);
                    cv.drawPicture(pic);
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    if (!raw.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)stream)) {
                        throw new RuntimeException("Error while compressing screenshot image.");
                    }
                    try {
                        stream.flush();
                        stream.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("I/O Error while capturing screenshot: " + e.getMessage());
                    }
                    finally {
                        Closeables.closeQuietly((Closeable)stream);
                    }
                    rawPng[0] = stream.toByteArray();
                    AndroidWebDriver.this.done = true;
                    AndroidWebDriver.this.syncObject.notify();
                }
            }
        });
        this.waitForDone(end, 10000L, "Failed to take screenshot.");
        return rawPng[0];
    }

    public <X> X getScreenshotAs(OutputType<X> target) throws WebDriverException {
        byte[] rawPng = this.takeScreenshot();
        String base64Png = new Base64Encoder().encode(rawPng);
        return (X)target.convertFromBase64Png(base64Png);
    }

    public ScreenOrientation getOrientation() {
        int value = this.activity.getRequestedOrientation();
        if (value == 0) {
            return ScreenOrientation.LANDSCAPE;
        }
        return ScreenOrientation.PORTRAIT;
    }

    public void rotate(ScreenOrientation orientation) {
        this.activity.setRequestedOrientation(this.getAndroidScreenOrientation(orientation));
    }

    private int getAndroidScreenOrientation(ScreenOrientation orientation) {
        if (ScreenOrientation.LANDSCAPE.equals((Object)orientation)) {
            return 0;
        }
        return 1;
    }

    public boolean isOnline() {
        return Settings.System.getInt((ContentResolver)this.getActivity().getContentResolver(), (String)"airplane_mode_on", (int)0) != 1;
    }

    public void setOnline(boolean online) throws WebDriverException {
        Settings.System.putInt((ContentResolver)this.getActivity().getContentResolver(), (String)"airplane_mode_on", (int)(online ? 0 : 1));
        Intent intent = new Intent("android.intent.action.AIRPLANE_MODE");
        intent.putExtra("state", online);
        this.getActivity().sendBroadcast(intent);
    }

    public TouchScreen getTouch() {
        return this.touchScreen;
    }

    private class AndroidNavigation
    implements WebDriver.Navigation {
        private AndroidNavigation() {
        }

        public void back() {
            if (AndroidWebDriver.this.view == null) {
                throw new WebDriverException("No open windows.");
            }
            AndroidWebDriver.this.pageDoneLoading = false;
            AndroidWebDriver.this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    AndroidWebDriver.this.view.goBack();
                }
            });
            this.waitForPageLoadToComplete();
        }

        public void forward() {
            if (AndroidWebDriver.this.view == null) {
                throw new WebDriverException("No open windows.");
            }
            AndroidWebDriver.this.pageDoneLoading = false;
            AndroidWebDriver.this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    AndroidWebDriver.this.view.goForward();
                }
            });
            this.waitForPageLoadToComplete();
        }

        public void to(final String url) {
            if (url == null) {
                return;
            }
            if (AndroidWebDriver.this.view == null) {
                throw new WebDriverException("No open windows.");
            }
            AndroidWebDriver.this.pageDoneLoading = false;
            AndroidWebDriver.this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        AndroidWebDriver.this.view.loadUrl(url);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            this.waitForPageLoadToComplete();
        }

        public void to(URL url) {
            this.to(url.toString());
        }

        public void refresh() {
            if (AndroidWebDriver.this.view == null) {
                throw new WebDriverException("No open windows.");
            }
            AndroidWebDriver.this.pageDoneLoading = false;
            AndroidWebDriver.this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    AndroidWebDriver.this.view.reload();
                }
            });
            this.waitForPageLoadToComplete();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitForPageLoadToComplete() {
            long timeout = System.currentTimeMillis() + 30000L;
            Object object = AndroidWebDriver.this.syncObject;
            synchronized (object) {
                while (!AndroidWebDriver.this.pageDoneLoading && System.currentTimeMillis() < timeout) {
                    try {
                        AndroidWebDriver.this.syncObject.wait(30000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    private class AndroidTimeouts
    implements WebDriver.Timeouts {
        private AndroidTimeouts() {
        }

        public WebDriver.Timeouts implicitlyWait(long time, TimeUnit unit) {
            AndroidWebDriver.this.implicitWait = TimeUnit.MILLISECONDS.convert(Math.max(0L, time), unit);
            return this;
        }

        public WebDriver.Timeouts setScriptTimeout(long time, TimeUnit unit) {
            return this;
        }

        public WebDriver.Timeouts pageLoadTimeout(long time, TimeUnit unit) {
            throw new UnsupportedOperationException("pageLoadTimeout");
        }
    }

    private class AndroidOptions
    implements WebDriver.Options {
        private AndroidOptions() {
        }

        public Logs logs() {
            return AndroidWebDriver.this.logs;
        }

        public void addCookie(Cookie cookie) {
            if (AndroidWebDriver.this.view == null) {
                throw new WebDriverException("No open windows.");
            }
            AndroidWebDriver.this.sessionCookieManager.addCookie(AndroidWebDriver.this.getCurrentUrl(), cookie);
        }

        public void deleteCookieNamed(String name) {
            if (AndroidWebDriver.this.view == null) {
                throw new WebDriverException("No open windows.");
            }
            AndroidWebDriver.this.sessionCookieManager.remove(AndroidWebDriver.this.getCurrentUrl(), name);
        }

        public void deleteCookie(Cookie cookie) {
            if (AndroidWebDriver.this.view == null) {
                throw new WebDriverException("No open windows.");
            }
            AndroidWebDriver.this.sessionCookieManager.remove(AndroidWebDriver.this.getCurrentUrl(), cookie.getName());
        }

        public void deleteAllCookies() {
            if (AndroidWebDriver.this.view == null) {
                throw new WebDriverException("No open windows.");
            }
            AndroidWebDriver.this.sessionCookieManager.removeAllCookies(AndroidWebDriver.this.getCurrentUrl());
        }

        public Set<Cookie> getCookies() {
            if (AndroidWebDriver.this.view == null) {
                throw new WebDriverException("No open windows.");
            }
            return AndroidWebDriver.this.sessionCookieManager.getAllCookies(AndroidWebDriver.this.getCurrentUrl());
        }

        public Cookie getCookieNamed(String name) {
            if (AndroidWebDriver.this.view == null) {
                throw new WebDriverException("No open windows.");
            }
            return AndroidWebDriver.this.sessionCookieManager.getCookie(AndroidWebDriver.this.getCurrentUrl(), name);
        }

        public WebDriver.Timeouts timeouts() {
            return new AndroidTimeouts();
        }

        public WebDriver.ImeHandler ime() {
            throw new UnsupportedOperationException("Not implementing IME input just yet.");
        }

        @Beta
        public WebDriver.Window window() {
            throw new UnsupportedOperationException("Window handling not supported on Android");
        }
    }

    private class AndroidTargetLocator
    implements WebDriver.TargetLocator {
        private AndroidTargetLocator() {
        }

        public WebElement activeElement() {
            return (WebElement)AndroidWebDriver.this.executeRawScript("(" + AndroidAtoms.ACTIVE_ELEMENT.getValue() + ")()");
        }

        public WebDriver defaultContent() {
            AndroidWebDriver.this.executeRawScript("(" + AndroidAtoms.DEFAULT_CONTENT.getValue() + ")()");
            return AndroidWebDriver.this;
        }

        public WebDriver frame(int index) {
            DomWindow window = (DomWindow)AndroidWebDriver.this.executeRawScript("(" + AndroidAtoms.FRAME_BY_INDEX.getValue() + ")(" + index + ")");
            if (window == null) {
                throw new NoSuchFrameException("Frame with index '" + index + "' does not exists.");
            }
            AndroidWebDriver.this.currentWindowOrFrame = window;
            return AndroidWebDriver.this;
        }

        public WebDriver frame(String frameNameOrId) {
            DomWindow window = (DomWindow)AndroidWebDriver.this.executeRawScript("(" + AndroidAtoms.FRAME_BY_ID_OR_NAME.getValue() + ")('" + frameNameOrId + "')");
            if (window == null) {
                throw new NoSuchFrameException("Frame with ID or name '" + frameNameOrId + "' does not exists.");
            }
            AndroidWebDriver.this.currentWindowOrFrame = window;
            return AndroidWebDriver.this;
        }

        public WebDriver frame(WebElement frameElement) {
            DomWindow window = (DomWindow)AndroidWebDriver.this.executeScript("return arguments[0].contentWindow;", (AndroidWebElement)((WrapsElement)frameElement).getWrappedElement());
            if (window == null) {
                throw new NoSuchFrameException("Frame does not exists.");
            }
            AndroidWebDriver.this.currentWindowOrFrame = window;
            return AndroidWebDriver.this;
        }

        public WebDriver window(final String nameOrHandle) {
            final boolean[] shouldhTrow = new boolean[]{false};
            AndroidWebDriver.this.done = false;
            long end = System.currentTimeMillis() + 10000L;
            AndroidWebDriver.this.activity.runOnUiThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = AndroidWebDriver.this.syncObject;
                    synchronized (object) {
                        ViewAdapter v = AndroidWebDriver.this.viewManager.getView(nameOrHandle);
                        if (v != null) {
                            AndroidWebDriver.this.view = v;
                        } else {
                            shouldhTrow[0] = true;
                        }
                        AndroidWebDriver.this.activity.setContentView((View)AndroidWebDriver.this.view.getUnderlyingView());
                        AndroidWebDriver.this.done = true;
                        AndroidWebDriver.this.syncObject.notify();
                    }
                }
            });
            AndroidWebDriver.this.waitForDone(end, 10000L, "Failed to switch to window: " + nameOrHandle);
            if (shouldhTrow[0]) {
                throw new NoSuchWindowException("Window '" + nameOrHandle + "' does not exist.");
            }
            return AndroidWebDriver.this;
        }

        public Alert alert() {
            if (AndroidWebDriver.this.view == null) {
                throw new WebDriverException("Asked for an alert without a window context. switchTo().window(...) first.");
            }
            Alert foundAlert = AlertManager.getAlertForView(AndroidWebDriver.this.view);
            if (foundAlert == null) {
                throw new NoAlertPresentException("No alert in current view.");
            }
            return foundAlert;
        }
    }

    private class AndroidFindBy
    implements SearchContext,
    FindsByTagName,
    FindsById,
    FindsByLinkText,
    FindsByName,
    FindsByXPath,
    FindsByCssSelector,
    FindsByClassName {
        private AndroidFindBy() {
        }

        public WebElement findElement(By by) {
            long start = System.currentTimeMillis();
            while (true) {
                try {
                    return by.findElement((SearchContext)AndroidWebDriver.this.findBy);
                }
                catch (NoSuchElementException e) {
                    if (System.currentTimeMillis() - start > AndroidWebDriver.this.implicitWait) {
                        throw e;
                    }
                    AndroidWebDriver.sleepQuietly(100L);
                    continue;
                }
                break;
            }
        }

        public List<WebElement> findElements(By by) {
            long start = System.currentTimeMillis();
            List found = by.findElements((SearchContext)AndroidWebDriver.this.findBy);
            while (found.isEmpty() && System.currentTimeMillis() - start <= AndroidWebDriver.this.implicitWait) {
                AndroidWebDriver.sleepQuietly(100L);
                found = by.findElements((SearchContext)this);
            }
            return found;
        }

        public WebElement findElementByLinkText(String using) {
            return AndroidWebDriver.this.element.getFinder().findElementByLinkText(using);
        }

        public List<WebElement> findElementsByLinkText(String using) {
            return AndroidWebDriver.this.element.getFinder().findElementsByLinkText(using);
        }

        public WebElement findElementById(String id) {
            return AndroidWebDriver.this.element.getFinder().findElementById(id);
        }

        public List<WebElement> findElementsById(String id) {
            return this.findElementsByXPath("//*[@id='" + id + "']");
        }

        public WebElement findElementByName(String using) {
            return AndroidWebDriver.this.element.getFinder().findElementByName(using);
        }

        public List<WebElement> findElementsByName(String using) {
            return AndroidWebDriver.this.element.getFinder().findElementsByName(using);
        }

        public WebElement findElementByTagName(String using) {
            return AndroidWebDriver.this.element.getFinder().findElementByTagName(using);
        }

        public List<WebElement> findElementsByTagName(String using) {
            return AndroidWebDriver.this.element.getFinder().findElementsByTagName(using);
        }

        public WebElement findElementByXPath(String using) {
            return AndroidWebDriver.this.element.getFinder().findElementByXPath(using);
        }

        public List<WebElement> findElementsByXPath(String using) {
            return AndroidWebDriver.this.element.getFinder().findElementsByXPath(using);
        }

        public WebElement findElementByPartialLinkText(String using) {
            return AndroidWebDriver.this.element.getFinder().findElementByPartialLinkText(using);
        }

        public List<WebElement> findElementsByPartialLinkText(String using) {
            return AndroidWebDriver.this.element.getFinder().findElementsByPartialLinkText(using);
        }

        public WebElement findElementByCssSelector(String using) {
            return AndroidWebDriver.this.element.getFinder().findElementByCssSelector(using);
        }

        public List<WebElement> findElementsByCssSelector(String using) {
            return AndroidWebDriver.this.element.getFinder().findElementsByCssSelector(using);
        }

        public WebElement findElementByClassName(String using) {
            return AndroidWebDriver.this.element.getFinder().findElementByClassName(using);
        }

        public List<WebElement> findElementsByClassName(String using) {
            return AndroidWebDriver.this.element.getFinder().findElementsByClassName(using);
        }
    }
}

