/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.android.library;

import android.view.View;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.google.common.base.Preconditions;
import org.openqa.selenium.android.library.AndroidWebDriver;
import org.openqa.selenium.android.library.ChromeClient;
import org.openqa.selenium.android.library.JavascriptExecutor;
import org.openqa.selenium.android.library.JavascriptInterface;
import org.openqa.selenium.android.library.ViewClient;
import org.openqa.selenium.android.library.WebViewFactory;

class WebDriverWebView {
    private static JavascriptInterface jsInterface = new JavascriptInterface(new JavascriptExecutor());
    private AndroidWebDriver driver;
    private WebViewFactory factory;
    private WebViewClient viewc;
    private WebChromeClient chromec;
    private View.OnFocusChangeListener focusListener;

    WebDriverWebView(AndroidWebDriver driver, WebViewFactory factory, WebViewClient viewc, WebChromeClient chromec, View.OnFocusChangeListener focusListener) {
        Preconditions.checkNotNull((Object)driver);
        Preconditions.checkNotNull((Object)factory);
        this.driver = driver;
        this.factory = factory;
        this.viewc = viewc;
        this.chromec = chromec;
        this.focusListener = focusListener == null ? new View.OnFocusChangeListener(){

            public void onFocusChange(View view, boolean b) {
            }
        } : focusListener;
    }

    public WebView create() {
        ChromeClient chromeClient = new ChromeClient(this.driver, this, this.chromec);
        ViewClient viewClient = new ViewClient(this.driver, this.viewc);
        WebView view = this.factory.createNewView(this.driver.getActivity());
        view.setWebChromeClient((WebChromeClient)chromeClient);
        view.setWebViewClient((WebViewClient)viewClient);
        view.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View view, boolean focused) {
                if (!focused) {
                    WebDriverWebView.this.driver.setEditAreaHasFocus(true);
                }
                WebDriverWebView.this.focusListener.onFocusChange(view, focused);
            }
        });
        view.addJavascriptInterface((Object)jsInterface, "webdriver");
        WebDriverWebView.initWebViewSettings(view);
        return view;
    }

    private WebDriverWebView() {
    }

    private static void initWebViewSettings(WebView view) {
        view.clearCache(true);
        view.clearFormData();
        view.clearHistory();
        view.clearView();
        view.requestFocus(130);
        view.setFocusable(true);
        view.setFocusableInTouchMode(true);
        WebSettings settings = view.getSettings();
        settings.setJavaScriptCanOpenWindowsAutomatically(true);
        settings.setSupportMultipleWindows(true);
        settings.setBuiltInZoomControls(true);
        settings.setJavaScriptEnabled(true);
        settings.setDatabaseEnabled(true);
        settings.setDomStorageEnabled(true);
        settings.setGeolocationEnabled(true);
        settings.setSaveFormData(true);
        settings.setRenderPriority(WebSettings.RenderPriority.HIGH);
        settings.setLoadWithOverviewMode(true);
        settings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NARROW_COLUMNS);
        settings.setDefaultZoom(WebSettings.ZoomDensity.valueOf((String)"MEDIUM"));
        settings.setUseWideViewPort(true);
        settings.setMinimumFontSize(1);
        settings.setMinimumLogicalFontSize(1);
        settings.setDefaultFontSize(16);
        settings.setDefaultFixedFontSize(13);
        view.enablePlatformNotifications();
        view.setNetworkAvailable(true);
    }
}

