/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.android.library;

import android.graphics.Bitmap;
import android.net.http.SslError;
import android.os.Message;
import android.view.KeyEvent;
import android.webkit.HttpAuthHandler;
import android.webkit.SslErrorHandler;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import java.util.logging.Level;
import org.openqa.selenium.android.library.AndroidWebDriver;
import org.openqa.selenium.android.library.Logger;

class ViewClient
extends WebViewClient {
    private final AndroidWebDriver driver;
    private final String LOG_TAG = ViewClient.class.getName();
    private final WebViewClient delegate;
    private String tmpUrl;

    public ViewClient(AndroidWebDriver driver, WebViewClient client) {
        this.driver = driver;
        this.delegate = client == null ? new WebViewClient() : client;
    }

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        Logger.log(Level.WARNING, this.LOG_TAG, "onReceiveError", description + ", error code: " + errorCode);
        this.delegate.onReceivedError(view, errorCode, description, failingUrl);
    }

    public void onFormResubmission(WebView view, Message dontResend, Message resend) {
        this.delegate.onFormResubmission(view, dontResend, resend);
    }

    public void doUpdateVisitedHistory(WebView view, String url, boolean isReload) {
        this.delegate.doUpdateVisitedHistory(view, url, isReload);
    }

    public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
        boolean shouldAcceptSslCerts = this.driver.getAcceptSslCerts();
        Logger.log(Level.WARNING, this.LOG_TAG, "onReceivedSslError", error.toString() + ", shouldAcceptSslCerts: " + shouldAcceptSslCerts);
        if (shouldAcceptSslCerts) {
            handler.proceed();
        } else {
            this.delegate.onReceivedSslError(view, handler, error);
        }
    }

    public void onReceivedHttpAuthRequest(WebView view, HttpAuthHandler handler, String host, String realm) {
        this.delegate.onReceivedHttpAuthRequest(view, handler, host, realm);
    }

    public boolean shouldOverrideKeyEvent(WebView view, KeyEvent event) {
        return this.delegate.shouldOverrideKeyEvent(view, event);
    }

    public void onUnhandledKeyEvent(WebView view, KeyEvent event) {
        this.delegate.onUnhandledKeyEvent(view, event);
    }

    public void onScaleChanged(WebView view, float oldScale, float newScale) {
        this.delegate.onScaleChanged(view, oldScale, newScale);
    }

    public void onReceivedLoginRequest(WebView view, String realm, String account, String args) {
        this.delegate.onReceivedLoginRequest(view, realm, account, args);
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        return this.delegate.shouldOverrideUrlLoading(view, url);
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        this.driver.setLastUrlLoaded(url);
        this.tmpUrl = url;
        this.driver.notifyPageStartedLoading();
        this.delegate.onPageStarted(view, url, favicon);
    }

    public void onPageFinished(WebView view, String url) {
        this.driver.setLastUrlLoaded(url);
        if (url.contains("#") && this.tmpUrl.equals(url.split("#")[0])) {
            this.driver.notifyPageDoneLoading();
        }
        this.delegate.onPageFinished(view, url);
    }

    public void onLoadResource(WebView view, String url) {
        this.delegate.onLoadResource(view, url);
    }

    public WebResourceResponse shouldInterceptRequest(WebView view, String url) {
        return this.delegate.shouldInterceptRequest(view, url);
    }

    public void onTooManyRedirects(WebView view, Message cancelMsg, Message continueMsg) {
        this.delegate.onTooManyRedirects(view, cancelMsg, continueMsg);
    }
}

