/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.android.library;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.webkit.WebView;
import java.lang.reflect.Method;

class NetworkStateHandler {
    private Activity activity;
    private IntentFilter filter;
    private BroadcastReceiver receiver;
    private boolean isConnected;
    private boolean isNetworkUp;
    private final WebView view;

    public NetworkStateHandler(Activity activity, final WebView view) {
        this.activity = activity;
        this.view = view;
        ConnectivityManager cm = (ConnectivityManager)activity.getSystemService("connectivity");
        NetworkInfo info = cm.getActiveNetworkInfo();
        if (info != null) {
            this.isConnected = info.isConnected();
            this.isNetworkUp = info.isAvailable();
        }
        this.filter = new IntentFilter();
        this.filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        this.receiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (intent.getAction().equals("android.net.conn.CONNECTIVITY_CHANGE")) {
                    NetworkInfo info = (NetworkInfo)intent.getParcelableExtra("networkInfo");
                    String typeName = info.getTypeName();
                    String subType = info.getSubtypeName();
                    NetworkStateHandler.this.isConnected = info.isConnected();
                    if (view != null) {
                        try {
                            Method setNetworkType = view.getClass().getMethod("setNetworkType", String.class, String.class);
                            setNetworkType.invoke((Object)view, typeName, subType == null ? "" : subType);
                            boolean noConnection = intent.getBooleanExtra("noConnectivity", false);
                            NetworkStateHandler.this.onNetworkChange(!noConnection);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
        };
    }

    public void onNetworkChange(boolean up) {
        if (up == this.isNetworkUp) {
            return;
        }
        this.isNetworkUp = up;
        if (this.view != null) {
            this.view.setNetworkAvailable(this.isNetworkUp);
        }
    }

    public boolean isNetworkUp() {
        return this.isNetworkUp;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public void onPause() {
        this.activity.unregisterReceiver(this.receiver);
    }

    public void onResume() {
        this.activity.registerReceiver(this.receiver, this.filter);
    }
}

